/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jsch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.ssh.EmbeddedSSHServer;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JschIntegrationTest {
    private static final String FILE_BASEDIR = "basedir.txt";
    private static final Path SSHD_ROOT_DIR = Paths.get("target/sshd", new String[0]);
    private static final Path KNOWN_HOSTS = SSHD_ROOT_DIR.resolve("known_hosts");
    private EmbeddedSSHServer sshServer;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-jsch-tests.war");
        archive.addClasses(new Class[]{EmbeddedSSHServer.class, AvailablePortFinder.class, EnvironmentUtils.class});
        archive.addAsResource((Asset)new StringAsset(System.getProperty("basedir")), FILE_BASEDIR);
        archive.setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "com.jcraft.jsch,org.apache.sshd");
            return builder.openStream();
        });
        return archive;
    }

    @Before
    public void setUp() throws Exception {
        this.sshServer = new EmbeddedSSHServer(SSHD_ROOT_DIR);
        this.sshServer.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.sshServer != null) {
            this.sshServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScpFile() throws Exception {
        File testFile = this.resolvePath(SSHD_ROOT_DIR).resolve("test.txt").toFile();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        try {
            Endpoint endpoint = camelctx.getEndpoint(this.getScpEndpointUri());
            Assert.assertFalse((boolean)testFile.exists());
            camelctx.createProducerTemplate().sendBodyAndHeader(endpoint, (Object)"Hello", "CamelFileName", (Object)"test.txt");
            Assert.assertTrue((boolean)testFile.exists());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path resolvePath(Path other) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/basedir.txt")));){
            Path path = Paths.get(reader.readLine(), new String[0]).resolve(other);
            return path;
        }
    }

    private String getScpEndpointUri() {
        return String.format("scp://%s/%s?username=admin&password=admin&knownHostsFile=%s", this.sshServer.getConnection(), SSHD_ROOT_DIR, KNOWN_HOSTS);
    }
}

