/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mllp;

import java.util.concurrent.TimeUnit;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import org.wildfly.camel.test.mllp.subA.Hl7MessageGenerator;
import org.wildfly.camel.test.mllp.subA.MllpClientResource;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class MllpTcpServerConsumerTest {
    @Rule
    public MllpClientResource mllpClient = new MllpClientResource();

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-mllp-tests");
        archive.addPackage(MllpClientResource.class.getPackage());
        archive.addClasses(new Class[]{AvailablePortFinder.class});
        return archive;
    }

    @Test
    public void testReceiveSingleMessage() throws Exception {
        this.mllpClient.setMllpHost("localhost");
        this.mllpClient.setMllpPort(AvailablePortFinder.getNextAvailable());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){
            int connectTimeout = 500;
            int responseTimeout = 5000;

            public void configure() throws Exception {
                String routeId = "mllp-test-receiver-route";
                ((RouteDefinition)this.fromF("mllp://%s:%d?autoAck=true&connectTimeout=%d&receiveTimeout=%d&reuseAddress=true", new Object[]{MllpTcpServerConsumerTest.this.mllpClient.getMllpHost(), MllpTcpServerConsumerTest.this.mllpClient.getMllpPort(), this.connectTimeout, this.responseTimeout}).routeId(routeId).log(LoggingLevel.INFO, routeId, "Test route received message")).to("mock:result");
            }
        });
        MockEndpoint mock = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        camelctx.start();
        try {
            this.mllpClient.connect();
            this.mllpClient.sendMessageAndWaitForAcknowledgement(Hl7MessageGenerator.generateMessage(), 10000);
            MockEndpoint.assertIsSatisfied((long)10L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{mock});
        }
        finally {
            this.mllpClient.disconnect();
            camelctx.stop();
        }
    }
}

