/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mllp.subA;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.mllp.subA.MllpJUnitResourceCorruptFrameException;
import org.wildfly.camel.test.mllp.subA.MllpJUnitResourceException;
import org.wildfly.camel.test.mllp.subA.MllpJUnitResourceTimeoutException;

public class MllpClientResource
extends ExternalResource {
    static final char START_OF_BLOCK = '\u000b';
    static final char END_OF_BLOCK = '\u001c';
    static final char END_OF_DATA = '\r';
    static final int END_OF_STREAM = -1;
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    Socket clientSocket;
    InputStream inputStream;
    OutputStream outputStream;
    String mllpHost = "0.0.0.0";
    int mllpPort = -1;
    boolean sendStartOfBlock = true;
    boolean sendEndOfBlock = true;
    boolean sendEndOfData = true;
    int connectTimeout = 5000;
    int soTimeout = 5000;
    boolean reuseAddress;
    boolean tcpNoDelay = true;
    DisconnectMethod disconnectMethod = DisconnectMethod.CLOSE;

    public MllpClientResource() {
    }

    public MllpClientResource(int port) {
        this.mllpPort = port;
    }

    public MllpClientResource(String host, int port) {
        this.mllpHost = host;
        this.mllpPort = port;
    }

    protected void before() throws Throwable {
        if (0 < this.mllpPort) {
            this.connect();
        }
        super.before();
    }

    protected void after() {
        super.after();
        this.close();
    }

    public void close() {
        try {
            if (null != this.inputStream) {
                this.clientSocket.close();
            }
        }
        catch (IOException e) {
            this.log.warn(String.format("Exception encountered closing connection to {}:{}", this.mllpHost, this.mllpPort), (Throwable)e);
        }
        finally {
            this.inputStream = null;
            this.outputStream = null;
            this.clientSocket = null;
        }
    }

    public void connect() {
        this.connect(this.connectTimeout);
    }

    public void connect(int connectTimeout) {
        try {
            this.clientSocket = new Socket();
            this.clientSocket.connect(new InetSocketAddress(this.mllpHost, this.mllpPort), connectTimeout);
            this.clientSocket.setSoTimeout(this.soTimeout);
            this.clientSocket.setSoLinger(false, -1);
            this.clientSocket.setReuseAddress(this.reuseAddress);
            this.clientSocket.setTcpNoDelay(this.tcpNoDelay);
            this.inputStream = this.clientSocket.getInputStream();
            this.outputStream = new BufferedOutputStream(this.clientSocket.getOutputStream(), 2048);
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to establish connection to %s:%s", this.mllpHost, this.mllpPort);
            this.log.error(errorMessage, (Throwable)e);
            throw new MllpJUnitResourceException(errorMessage, e);
        }
    }

    public void reset() {
        try {
            this.clientSocket.setSoLinger(true, 0);
        }
        catch (SocketException socketEx) {
            this.log.warn("Exception encountered setting set SO_LINGER to force a TCP reset", (Throwable)socketEx);
        }
        try {
            if (null != this.inputStream) {
                this.clientSocket.close();
            }
        }
        catch (IOException e) {
            this.log.warn(String.format("Exception encountered resetting connection to {}:{}", this.mllpHost, this.mllpPort), (Throwable)e);
        }
        finally {
            this.inputStream = null;
            this.outputStream = null;
            this.clientSocket = null;
        }
    }

    public void disconnect() {
        if (DisconnectMethod.RESET == this.disconnectMethod) {
            this.reset();
        } else {
            this.close();
        }
    }

    public DisconnectMethod getDisconnectMethod() {
        return this.disconnectMethod;
    }

    public boolean isConnected() {
        return this.clientSocket.isConnected() && !this.clientSocket.isClosed();
    }

    public void sendData(String data) {
        boolean disconnectAfterSend = false;
        this.sendData(data, disconnectAfterSend);
    }

    public void sendData(String data, boolean disconnectAfterSend) {
        byte[] payloadBytes = data.getBytes();
        try {
            this.outputStream.write(payloadBytes, 0, payloadBytes.length);
        }
        catch (IOException e) {
            this.log.error("Unable to send raw string", (Throwable)e);
            throw new MllpJUnitResourceException("Unable to send raw string", e);
        }
        if (disconnectAfterSend) {
            this.log.warn("Closing TCP connection");
            this.disconnect();
        }
    }

    public void sendFramedData(String hl7Message) {
        boolean disconnectAfterSend = false;
        this.sendFramedData(hl7Message, disconnectAfterSend);
    }

    public void sendFramedData(String hl7Message, boolean disconnectAfterSend) {
        if (null == this.clientSocket) {
            this.connect();
        }
        if (!this.clientSocket.isConnected()) {
            throw new MllpJUnitResourceException("Cannot send message - client is not connected");
        }
        if (null == this.outputStream) {
            throw new MllpJUnitResourceException("Cannot send message - output stream is null");
        }
        byte[] payloadBytes = hl7Message.getBytes();
        try {
            if (this.sendStartOfBlock) {
                this.outputStream.write(11);
            } else {
                this.log.warn("Not sending START_OF_BLOCK");
            }
            this.outputStream.write(payloadBytes, 0, payloadBytes.length);
            if (this.sendEndOfBlock) {
                this.outputStream.write(28);
            } else {
                this.log.warn("Not sending END_OF_BLOCK");
            }
            if (this.sendEndOfData) {
                this.outputStream.write(13);
            } else {
                this.log.warn("Not sending END_OF_DATA");
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.log.error("Unable to send HL7 message", (Throwable)e);
            throw new MllpJUnitResourceException("Unable to send HL7 message", e);
        }
        if (disconnectAfterSend) {
            this.log.warn("Closing TCP connection");
            this.disconnect();
        }
    }

    public void sendFramedDataInMultiplePackets(String hl7Message, byte flushByte) {
        this.sendFramedDataInMultiplePackets(hl7Message, flushByte, false);
    }

    public void sendFramedDataInMultiplePackets(String hl7Message, byte flushByte, boolean disconnectAfterSend) {
        if (null == this.clientSocket) {
            this.connect();
        }
        if (!this.clientSocket.isConnected()) {
            throw new MllpJUnitResourceException("Cannot send message - client is not connected");
        }
        if (null == this.outputStream) {
            throw new MllpJUnitResourceException("Cannot send message - output stream is null");
        }
        byte[] payloadBytes = hl7Message.getBytes();
        try {
            if (this.sendStartOfBlock) {
                this.outputStream.write(11);
            } else {
                this.log.warn("Not sending START_OF_BLOCK");
            }
            for (int i = 0; i < payloadBytes.length; ++i) {
                this.outputStream.write(payloadBytes[i]);
                if (flushByte != payloadBytes[i]) continue;
                this.outputStream.flush();
            }
            if (this.sendEndOfBlock) {
                this.outputStream.write(28);
            } else {
                this.log.warn("Not sending END_OF_BLOCK");
            }
            if (this.sendEndOfData) {
                this.outputStream.write(13);
            } else {
                this.log.warn("Not sending END_OF_DATA");
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.log.error("Unable to send HL7 message", (Throwable)e);
            throw new MllpJUnitResourceException("Unable to send HL7 message", e);
        }
        if (disconnectAfterSend) {
            this.log.warn("Closing TCP connection");
            this.disconnect();
        }
    }

    public String receiveFramedData() throws SocketException, SocketTimeoutException {
        return this.receiveFramedData(this.soTimeout);
    }

    public String receiveFramedData(int timout) throws SocketException, SocketTimeoutException {
        if (!this.isConnected()) {
            throw new MllpJUnitResourceException("Cannot receive acknowledgement - client is not connected");
        }
        if (null == this.outputStream) {
            throw new MllpJUnitResourceException("Cannot receive acknowledgement - output stream is null");
        }
        this.clientSocket.setSoTimeout(timout);
        StringBuilder acknowledgement = new StringBuilder();
        try {
            int firstByte = this.inputStream.read();
            if (11 != firstByte) {
                if (this.isConnected()) {
                    if (-1 == firstByte) {
                        this.log.warn("END_OF_STREAM reached while waiting for START_OF_BLOCK - closing socket");
                        try {
                            this.clientSocket.close();
                        }
                        catch (Exception ex) {
                            this.log.warn("Exception encountered closing socket after receiving END_OF_STREAM while waiting for START_OF_BLOCK");
                        }
                        return "";
                    }
                    this.log.error("Acknowledgement did not start with START_OF_BLOCK: {}", (Object)firstByte);
                    throw new MllpJUnitResourceCorruptFrameException("Message did not start with START_OF_BLOCK");
                }
                throw new MllpJUnitResourceException("Connection terminated");
            }
            boolean readingMessage = true;
            block10: while (readingMessage) {
                int nextByte = this.inputStream.read();
                switch (nextByte) {
                    case -1: {
                        throw new MllpJUnitResourceCorruptFrameException("Reached end of stream before END_OF_BLOCK");
                    }
                    case 11: {
                        throw new MllpJUnitResourceCorruptFrameException("Received START_OF_BLOCK before END_OF_BLOCK");
                    }
                    case 28: {
                        if (13 != this.inputStream.read()) {
                            throw new MllpJUnitResourceCorruptFrameException("END_OF_BLOCK was not followed by END_OF_DATA");
                        }
                        readingMessage = false;
                        continue block10;
                    }
                }
                acknowledgement.append((char)nextByte);
            }
        }
        catch (SocketTimeoutException timeoutEx) {
            if (0 < acknowledgement.length()) {
                this.log.error("Timeout waiting for acknowledgement", (Throwable)timeoutEx);
            } else {
                this.log.error("Timeout while reading acknowledgement\n" + acknowledgement.toString().replace('\r', '\n'), (Throwable)timeoutEx);
            }
            throw new MllpJUnitResourceTimeoutException("Timeout while reading acknowledgement", timeoutEx);
        }
        catch (IOException e) {
            this.log.error("Unable to read HL7 acknowledgement", (Throwable)e);
            throw new MllpJUnitResourceException("Unable to read HL7 acknowledgement", e);
        }
        return acknowledgement.toString();
    }

    public String receiveData() throws SocketException, SocketTimeoutException {
        return this.receiveData(this.soTimeout);
    }

    public String receiveData(int timeout) throws SocketException, SocketTimeoutException {
        this.clientSocket.setSoTimeout(timeout);
        StringBuilder availableInput = new StringBuilder();
        try {
            do {
                availableInput.append((char)this.inputStream.read());
            } while (0 < this.inputStream.available());
        }
        catch (SocketTimeoutException timeoutEx) {
            this.log.error("Timeout while receiving available input", (Throwable)timeoutEx);
            throw new MllpJUnitResourceTimeoutException("Timeout while receiving available input", timeoutEx);
        }
        catch (IOException e) {
            this.log.warn("Exception encountered eating available input", (Throwable)e);
            throw new MllpJUnitResourceException("Exception encountered eating available input", e);
        }
        return availableInput.toString();
    }

    public String eatData() throws SocketException, SocketTimeoutException {
        return this.eatData(this.soTimeout);
    }

    public String eatData(int timeout) throws SocketException {
        this.clientSocket.setSoTimeout(timeout);
        StringBuilder availableInput = new StringBuilder();
        try {
            while (0 < this.inputStream.available()) {
                availableInput.append((char)this.inputStream.read());
            }
        }
        catch (IOException e) {
            this.log.warn("Exception encountered eating available input", (Throwable)e);
            throw new MllpJUnitResourceException("Exception encountered eating available input", e);
        }
        return availableInput.toString();
    }

    public String sendMessageAndWaitForAcknowledgement(String hl7Data) throws SocketException, SocketTimeoutException {
        this.sendFramedData(hl7Data);
        return this.receiveFramedData();
    }

    public String sendMessageAndWaitForAcknowledgement(String hl7Data, int acknwoledgementTimeout) throws SocketException, SocketTimeoutException {
        this.sendFramedData(hl7Data);
        return this.receiveFramedData(acknwoledgementTimeout);
    }

    public String getMllpHost() {
        return this.mllpHost;
    }

    public void setMllpHost(String mllpHost) {
        this.mllpHost = mllpHost;
    }

    public int getMllpPort() {
        return this.mllpPort;
    }

    public void setMllpPort(int mllpPort) {
        this.mllpPort = mllpPort;
    }

    public boolean isSendStartOfBlock() {
        return this.sendStartOfBlock;
    }

    public void setSendStartOfBlock(boolean sendStartOfBlock) {
        this.sendStartOfBlock = sendStartOfBlock;
    }

    public boolean isSendEndOfBlock() {
        return this.sendEndOfBlock;
    }

    public void setSendEndOfBlock(boolean sendEndOfBlock) {
        this.sendEndOfBlock = sendEndOfBlock;
    }

    public boolean isSendEndOfData() {
        return this.sendEndOfData;
    }

    public void setSendEndOfData(boolean sendEndOfData) {
        this.sendEndOfData = sendEndOfData;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setDisconnectMethod(DisconnectMethod disconnectMethod) {
        this.disconnectMethod = disconnectMethod;
    }

    public static enum DisconnectMethod {
        CLOSE,
        RESET;

    }
}

