/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.netty;

import java.io.PrintWriter;
import java.net.Socket;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class NettyIntegrationTest {
    private static final String SOCKET_HOST = "localhost";
    private static final int SOCKET_PORT = 7998;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-netty-test.war");
        archive.addAsWebResource("netty/netty-camel-context.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyTcpSocket() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("netty4:tcp://localhost:7998?textline=true").transform((Expression)this.simple("Hello ${body}"))).inOnly("seda:end");
            }
        });
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("seda:end").createPollingConsumer();
            pollingConsumer.start();
            Socket socket = new Socket(SOCKET_HOST, 7998);
            socket.setKeepAlive(true);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            try {
                out.write("Kermit\n");
            }
            finally {
                out.close();
                socket.close();
            }
            String result = (String)pollingConsumer.receive(3000L).getIn().getBody(String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployedContext() throws Exception {
        CamelContextRegistry registry = (CamelContextRegistry)ServiceLocator.getRequiredService(CamelContextRegistry.class);
        CamelContext camelctx = registry.getCamelContext("netty-context");
        Assert.assertNotNull((String)"CamelContext not null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        PollingConsumer pollingConsumer = camelctx.getEndpoint("seda:end").createPollingConsumer();
        pollingConsumer.start();
        Socket socket = new Socket(SOCKET_HOST, 7999);
        socket.setKeepAlive(true);
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        try {
            out.write("Kermit\n");
        }
        finally {
            out.close();
            socket.close();
        }
        String result = (String)pollingConsumer.receive().getIn().getBody(String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }
}

