/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.schematron;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SchematronIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-schematron-tests.jar")).addAsResource("schematron/person.sch", "schematron/person.sch")).addAsResource("schematron/person.xsd", "schematron/person.xsd")).addAsResource("schematron/person-invalid.xml", "schematron/person-invalid.xml")).addAsResource("schematron/person-valid.xml", "schematron/person-valid.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchematronValidation() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("schematron://schematron/person.sch")).choice().when((Predicate)this.simple("${in.header.CamelSchematronValidationStatus} == 'SUCCESS'")).setBody((Expression)this.constant("PASS"))).otherwise().setBody((Expression)this.constant("FAIL"));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            String valid = (String)template.requestBody("direct:start", (Object)this.readResource("person-valid.xml"), String.class);
            String invalid = (String)template.requestBody("direct:start", (Object)this.readResource("person-invalid.xml"), String.class);
            Assert.assertEquals((Object)valid, (Object)"PASS");
            Assert.assertEquals((Object)invalid, (Object)"FAIL");
        }
        finally {
            camelctx.stop();
        }
    }

    private String readResource(String resource) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)this.getClass().getResourceAsStream("/schematron/" + resource), (OutputStream)out);
        return new String(out.toByteArray());
    }
}

