/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.stax;

import java.io.InputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.stax.StAXBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Record;
import org.wildfly.camel.test.common.types.Records;
import org.wildfly.camel.test.stax.subA.ElementCountingHandler;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class StaxIntegrationTest {
    private static final String RECORDS_XML = "records.xml";

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-stax-tests.jar")).addClasses(new Class[]{ElementCountingHandler.class, Record.class, Records.class})).addAsResource("stax/records.xml", RECORDS_XML)).setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "org.jdom");
            return builder.openStream();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaxHandler() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").toF("stax:%s", new Object[]{ElementCountingHandler.class.getName()});
            }
        });
        camelctx.start();
        try {
            InputStream input = this.getClass().getResourceAsStream("/records.xml");
            ProducerTemplate template = camelctx.createProducerTemplate();
            ElementCountingHandler handler = (ElementCountingHandler)template.requestBody("direct:start", (Object)input, ElementCountingHandler.class);
            Assert.assertEquals((long)6L, (long)handler.getCount());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaxJAXBSplit() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").split(StAXBuilder.stax(Record.class)).streaming().to("mock:result");
            }
        });
        MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
        mockEndpoint.expectedMessageCount(5);
        ((ValueBuilder)mockEndpoint.allMessages().body()).isInstanceOf(Record.class);
        camelctx.start();
        try {
            InputStream input = this.getClass().getResourceAsStream("/records.xml");
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBody("direct:start", (Object)input);
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }
}

