/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.zookeeper;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import org.wildfly.camel.test.common.zookeeper.EmbeddedZookeeper;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ZookeeperConsumerIntegrationTest {
    static EmbeddedZookeeper server;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"zookeeper-integration-tests");
        archive.addClasses(new Class[]{EmbeddedZookeeper.class, AvailablePortFinder.class});
        return archive;
    }

    @Before
    public void before() throws Exception {
        server = new EmbeddedZookeeper().startup(1, TimeUnit.SECONDS);
    }

    @After
    public void after() throws Exception {
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZookeeperConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("zookeeper://" + server.getConnection() + "/somenode").to("mock:end");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:end", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            mockEndpoint.expectedBodiesReceived(new Object[]{"Kermit"});
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.sendBody("zookeeper://" + server.getConnection() + "/somenode?create=true", (Object)"Kermit");
            mockEndpoint.assertIsSatisfied(10000L);
        }
        finally {
            camelctx.stop();
        }
    }
}

