/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.policy;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.security.LoginContextBuilder;

@CamelAware
@RunWith(value=Arquillian.class)
public class UserDomainLoginTestCase {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"client-login-test");
        return archive;
    }

    @Test
    public void testOtherDomainAccess() throws Exception {
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.AUTHENTICATION);
        LoginContext loginContext = builder.username("user1").password("appl-pa$$wrd1".toCharArray()).build();
        loginContext.login();
    }

    @Test
    public void testOtherDomainFail() throws Exception {
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.AUTHENTICATION);
        LoginContext loginContext = builder.username("user2").password("appl-pa$$wrd2".toCharArray()).build();
        try {
            loginContext.login();
            Assert.fail((String)"LoginException expected");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    @Test
    public void testUserDomainOtherAccess() throws Exception {
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.AUTHENTICATION).domain("user-domain");
        LoginContext loginContext = builder.username("user2").encryptedPassword("appl-pa$$wrd2".toCharArray()).build();
        loginContext.login();
    }
}

