/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.sap;

import org.apache.camel.Component;
import org.apache.camel.impl.DefaultCamelContext;
import org.fusesource.camel.component.sap.SapQueuedIDocDestinationComponent;
import org.fusesource.camel.component.sap.SapQueuedIDocListDestinationComponent;
import org.fusesource.camel.component.sap.SapQueuedRfcDestinationComponent;
import org.fusesource.camel.component.sap.SapSynchronousRfcDestinationComponent;
import org.fusesource.camel.component.sap.SapSynchronousRfcServerComponent;
import org.fusesource.camel.component.sap.SapTransactionalIDocListDestinationComponent;
import org.fusesource.camel.component.sap.SapTransactionalIDocListServerComponent;
import org.fusesource.camel.component.sap.SapTransactionalRfcDestinationComponent;
import org.fusesource.camel.component.sap.SapTransactionalRfcServerComponent;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SAPIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-sap-tests.jar");
    }

    @Before
    public void setUp() {
        try {
            ModuleLoader moduleLoader = Module.getCallerModuleLoader();
            moduleLoader.loadModule(ModuleIdentifier.create((String)"com.sap.conn.jco"));
        }
        catch (ModuleLoadException ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    @Test
    public void testIDocDestinationComponentLoads() {
        SapTransactionalIDocListDestinationComponent component = this.getComponent("sap-idoclist-destination", SapTransactionalIDocListDestinationComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testIDocListServerComponentLoads() {
        SapTransactionalIDocListServerComponent component = this.getComponent("sap-idoclist-server", SapTransactionalIDocListServerComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testQueuedIDocDestinationComponentLoads() {
        SapQueuedIDocDestinationComponent component = this.getComponent("sap-qidoc-destination", SapQueuedIDocDestinationComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testQueuedIDocListDestinationComponentLoads() {
        SapQueuedIDocListDestinationComponent component = this.getComponent("sap-qidoclist-destination", SapQueuedIDocListDestinationComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testQueuedRfcDestinationComponentLoads() {
        SapQueuedRfcDestinationComponent component = this.getComponent("sap-qrfc-destination", SapQueuedRfcDestinationComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testSynchronousRfcDestinationComponentLoads() {
        SapSynchronousRfcDestinationComponent component = this.getComponent("sap-srfc-destination", SapSynchronousRfcDestinationComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testSynchronousRfcServerComponentLoads() {
        SapSynchronousRfcServerComponent component = this.getComponent("sap-srfc-server", SapSynchronousRfcServerComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testTransactionalRfcDestinationComponentLoads() {
        SapTransactionalRfcDestinationComponent component = this.getComponent("sap-trfc-destination", SapTransactionalRfcDestinationComponent.class);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testTransactionalRfcServerComponentLoads() {
        SapTransactionalRfcServerComponent component = this.getComponent("sap-trfc-server", SapTransactionalRfcServerComponent.class);
        Assert.assertNotNull((Object)component);
    }

    private <T extends Component> T getComponent(String name, Class<T> componentType) {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        return (T)camelctx.getComponent(name, componentType);
    }
}

