/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.policy;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Policy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.security.DomainAuthorizationPolicy;
import org.wildfly.extension.camel.security.DomainPrincipal;
import org.wildfly.extension.camel.security.EncodedUsernamePasswordPrincipal;

@CamelAware
@RunWith(value=Arquillian.class)
public class SecuredRouteTestCase {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"secured-route-test");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoAuthenticationHeader() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").policy((Policy)new DomainAuthorizationPolicy()).transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            try {
                producer.requestBody("direct:start", (Object)"Kermit", String.class);
                Assert.fail((String)"CamelExecutionException expected");
            }
            catch (CamelExecutionException camelExecutionException) {
                // empty catch block
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCredentials() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").policy((Policy)new DomainAuthorizationPolicy()).transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            try {
                Subject subject = this.getAuthenticationToken("user-domain", "user2", "bogus");
                producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
                Assert.fail((String)"CamelExecutionException expected");
            }
            catch (CamelExecutionException camelExecutionException) {
                // empty catch block
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsufficientRoles() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").policy((Policy)new DomainAuthorizationPolicy().roles(new String[]{"Role3"})).transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            try {
                Subject subject = this.getAuthenticationToken("user-domain", "user2", "appl-pa$$wrd2");
                producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
                Assert.fail((String)"CamelExecutionException expected");
            }
            catch (CamelExecutionException camelExecutionException) {
                // empty catch block
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticatedAccess() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").policy((Policy)new DomainAuthorizationPolicy()).transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Subject subject = this.getAuthenticationToken("user-domain", "user2", "appl-pa$$wrd2");
            String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoleBasedAccess() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").policy((Policy)new DomainAuthorizationPolicy().roles(new String[]{"Role2"})).transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Subject subject = this.getAuthenticationToken("user-domain", "user2", "appl-pa$$wrd2");
            String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    Subject getAuthenticationToken(String domain, String username, String password) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new DomainPrincipal(domain));
        subject.getPrincipals().add((Principal)new EncodedUsernamePasswordPrincipal(username, password.toCharArray()));
        return subject;
    }
}

