/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.weather;

import co.freeside.betamax.Betamax;
import co.freeside.betamax.Recorder;
import java.io.File;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class WeatherIntegrationTest {
    protected Logger log = LoggerFactory.getLogger(WeatherIntegrationTest.class);
    @Rule
    public Recorder recorder = new Recorder();

    @Deployment
    public static WebArchive createDeployment() throws Exception {
        File[] libraryDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve(new String[]{"co.freeside:betamax", "org.codehaus.groovy:groovy-all"})).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-weather-tests.war");
        archive.addAsLibraries(libraryDependencies);
        archive.addAsResource("betamax.properties", "betamax.properties");
        return archive;
    }

    @Test
    public void testComponentLoads() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("weather:foo?location=Madrid,Spain&period=7 days");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.weather.WeatherEndpoint");
        camelctx.stop();
    }

    @Test
    @Betamax(tape="madrid-weather-report")
    public void testGetWeather() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        String response = camelctx.createProducerTemplate().requestBody("weather:foo?location=Madrid,Spain&period=7 days", (Object)"").toString();
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((String)"Contains ", (boolean)response.contains(",\"name\":\"Madrid\","));
        camelctx.stop();
    }
}

