/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.xmlbeans;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.xmlbeans.Customer;
import org.wildfly.camel.xmlbeans.LineItem;
import org.wildfly.camel.xmlbeans.PurchaseOrderDocument;
import org.wildfly.camel.xmlbeans.impl.PurchaseOrderDocumentImpl;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class XmlBeansIntegrationTest {
    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"xmlbeans-tests.war");
        archive.addAsResource("xmlbeans/xml/purchaseOrder.xml", "purchaseOrder.xml");
        archive.addAsResource("xmlbeans/xsd/purchaseOrder.xsd", "org/wildfly/camel/xsd/purchaseOrder.xsd");
        archive.addAsResource(new File("target/generated-classes/xmlbeans/schemaorg_apache_xmlbeans"));
        archive.addPackage(PurchaseOrderDocument.class.getPackage());
        archive.addPackage(PurchaseOrderDocumentImpl.class.getPackage());
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlBeansUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().xmlBeans();
            }
        });
        try {
            camelctx.start();
            String orderXml = this.readPurchaseOrderXml();
            ProducerTemplate producer = camelctx.createProducerTemplate();
            PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)producer.requestBody("direct:start", (Object)orderXml, PurchaseOrderDocument.class);
            PurchaseOrderDocument.PurchaseOrder purchaseOrder = purchaseOrderDocument.getPurchaseOrder();
            Customer customer = purchaseOrder.getCustomer();
            LineItem[] lineItems = purchaseOrder.getLineItemArray();
            Assert.assertEquals((Object)customer.getName(), (Object)"John Doe");
            Assert.assertEquals((Object)customer.getAddress(), (Object)"Foo, Bar");
            Assert.assertEquals((long)lineItems.length, (long)2L);
            Assert.assertEquals((Object)lineItems[0].getDescription(), (Object)"Bird Food");
            Assert.assertEquals((Object)lineItems[0].getPrice(), (Object)new BigDecimal("10.99"));
            Assert.assertEquals((Object)lineItems[0].getQuantity(), (Object)new BigInteger("5"));
            Assert.assertEquals((Object)lineItems[1].getDescription(), (Object)"Cat Food");
            Assert.assertEquals((Object)lineItems[1].getPrice(), (Object)new BigDecimal("5.99"));
            Assert.assertEquals((Object)lineItems[1].getQuantity(), (Object)new BigInteger("4"));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlBeansMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().xmlBeans();
            }
        });
        try {
            camelctx.start();
            PurchaseOrderDocument purchaseOrderDocument = PurchaseOrderDocument.Factory.newInstance();
            PurchaseOrderDocument.PurchaseOrder purchaseOrder = purchaseOrderDocument.addNewPurchaseOrder();
            Customer customer = purchaseOrder.addNewCustomer();
            customer.setName("John Doe");
            customer.setAddress("Foo, Bar");
            LineItem birdFoodLineItem = purchaseOrder.addNewLineItem();
            birdFoodLineItem.setDescription("Bird Food");
            birdFoodLineItem.setPrice(new BigDecimal("10.99"));
            birdFoodLineItem.setQuantity(new BigInteger("5"));
            LineItem catFoodLineItem = purchaseOrder.addNewLineItem();
            catFoodLineItem.setDescription("Cat Food");
            catFoodLineItem.setPrice(new BigDecimal("5.99"));
            catFoodLineItem.setQuantity(new BigInteger("4"));
            String expected = this.readPurchaseOrderXml();
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String actual = (String)producer.requestBody("direct:start", (Object)purchaseOrderDocument, String.class);
            Assert.assertEquals((Object)expected.replaceAll("\\s+", ""), (Object)actual.replaceAll("\\s+", ""));
        }
        finally {
            camelctx.stop();
        }
    }

    private String readPurchaseOrderXml() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)this.getClass().getResourceAsStream("/purchaseOrder.xml"), (OutputStream)out);
        return new String(out.toByteArray());
    }
}

