/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.linkedin;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.linkedin.LinkedInComponent;
import org.apache.camel.component.linkedin.LinkedInConfiguration;
import org.apache.camel.component.linkedin.api.OAuthScope;
import org.apache.camel.component.linkedin.api.model.CompanySearch;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.IntrospectionSupport;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class LinkedInIntegrationTest {
    private static final String LINKEDIN_REDIRECT_URI = "http://localhost";
    private static final String LINKEDIN_SCOPES = "r_basicprofile";

    @Deployment
    public static JavaArchive deployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"linkedin-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchCompanies() throws Exception {
        Map<String, Object> linkedInOptions = this.createLinkedInOptions();
        Assume.assumeTrue((linkedInOptions.size() == LinkedInOption.values().length ? 1 : 0) != 0);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct://SEARCHCOMPANIES").to("linkedin://search/searchCompanies");
            }
        });
        linkedInOptions.put("redirectUri", LINKEDIN_REDIRECT_URI);
        linkedInOptions.put("scopes", OAuthScope.fromValues((String[])LINKEDIN_SCOPES.split(",")));
        LinkedInConfiguration configuration = new LinkedInConfiguration();
        IntrospectionSupport.setProperties((Object)configuration, linkedInOptions);
        LinkedInComponent component = new LinkedInComponent((CamelContext)camelctx);
        component.setConfiguration(configuration);
        camelctx.addComponent("linkedin", (Component)component);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelLinkedIn.fields", "");
        headers.put("CamelLinkedIn.keywords", "linkedin");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            CompanySearch result = (CompanySearch)producer.requestBodyAndHeaders("direct://SEARCHCOMPANIES", null, headers, CompanySearch.class);
            Assert.assertNotNull((String)"CompanySearch not null", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    protected Map<String, Object> createLinkedInOptions() throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (LinkedInOption option : LinkedInOption.values()) {
            String envVar = System.getenv(option.name());
            if (envVar == null || envVar.length() == 0) {
                options.clear();
                continue;
            }
            options.put(option.configPropertyName, envVar);
        }
        return options;
    }

    private static enum LinkedInOption {
        LINKEDIN_USERNAME("userName"),
        LINKEDIN_PASSWORD("userPassword"),
        LINKEDIN_CLIENT_ID("clientId"),
        LINKEDIN_CLIENT_SECRET("clientSecret");

        private String configPropertyName;

        private LinkedInOption(String configPropertyName) {
            this.configPropertyName = configPropertyName;
        }
    }
}

