/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.nats;

import io.nats.client.Connection;
import io.nats.client.ConnectionFactory;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.nats.NatsConsumer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.rule.ExecutableResource;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class NatsIntegrationTest {
    private static final String NATS_DOWNLOAD_BASE_URL = "https://github.com/nats-io/gnatsd/releases/download";
    private static final String NATS_VERSION = "v0.9.4";
    @Rule
    public ExecutableResource nats = new ExecutableResource().builder().downloadFrom(NatsIntegrationTest.resolveDownloadURL()).executable(String.format("%s/gnatsd", NatsIntegrationTest.resolveExecutableName())).args("-DV -a 127.0.0.1").waitForPort(4222).build();

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-nats-tests.jar")).addClasses(new Class[]{EnvironmentUtils.class, ExecutableResource.class});
    }

    @Test
    public void testNatsComponent() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("nats://localhost:4222?topic=test");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.nats.NatsEndpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNatsRoutes() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        try {
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("nats://localhost:4222?topic=test").id("nats-route")).to("mock:result");
                }
            });
            MockEndpoint to = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            to.expectedBodiesReceived(new Object[]{"{Subject=test;Reply=null;Payload=<test-message>}"});
            to.expectedMessageCount(1);
            camelctx.start();
            NatsConsumer consumer = (NatsConsumer)camelctx.getRoute("nats-route").getConsumer();
            int count = 0;
            while (!consumer.isSubscribed()) {
                Thread.sleep(500L);
                if (++count <= 10) continue;
                throw new IllegalStateException("Gave up waiting for nats consumer to subscribe to topic");
            }
            Properties opts = new Properties();
            opts.put("servers", "nats://localhost:4222");
            ConnectionFactory factory = new ConnectionFactory(opts);
            Connection connection = factory.createConnection();
            connection.publish("test", "test-message".getBytes());
            to.assertIsSatisfied(5000L);
        }
        finally {
            camelctx.stop();
        }
    }

    private static String resolveDownloadURL() {
        return String.format("%s/%s/%s.zip", NATS_DOWNLOAD_BASE_URL, NATS_VERSION, NatsIntegrationTest.resolveExecutableName());
    }

    private static String resolveExecutableName() {
        String osName = "linux";
        if (EnvironmentUtils.isMac()) {
            osName = "darwin";
        } else if (EnvironmentUtils.isWindows()) {
            osName = "windows";
        }
        return String.format("gnatsd-%s-%s-amd64", NATS_VERSION, osName);
    }
}

