/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.rss;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import software.betamax.junit.Betamax;
import software.betamax.junit.RecorderRule;

@CamelAware
@RunWith(value=Arquillian.class)
public class RSSIntegrationTest {
    @Rule
    public RecorderRule recorder = new RecorderRule();

    @Deployment
    public static WebArchive deployment() {
        File[] libraryDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("software.betamax:betamax-junit")).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"rss-tests.war");
        archive.addAsLibraries(libraryDependencies);
        archive.addAsResource("betamax.properties", "betamax.properties");
        return archive;
    }

    @Test
    @Betamax(tape="redhat-rss")
    public void testEndpointClass() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("rss://http://www.redhat.com/en/rss/press-releases?splitEntries=true&consumer.initialDelay=200&consumer.delay=1000").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                    }
                })).to("mock:result");
            }
        });
        camelctx.start();
        try {
            Assert.assertTrue((String)"Countdown reached zero", (boolean)latch.await(30L, TimeUnit.SECONDS));
        }
        finally {
            camelctx.stop();
        }
    }
}

