/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.salesforce;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.IntrospectionSupport;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.salesforce.dto.Opportunity;
import org.wildfly.camel.test.salesforce.dto.QueryRecordsOpportunity;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SalesforceIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-salesforce-tests")).addPackage(Opportunity.class.getPackage());
    }

    @Test
    public void testComponentLoads() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("salesforce:getVersions");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.salesforce.SalesforceEndpoint");
        camelctx.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSalesforceQuery() throws Exception {
        Map<String, Object> salesforceOptions = this.createSalesforceOptions();
        Assume.assumeTrue((salesforceOptions.size() == SalesforceOption.values().length ? 1 : 0) != 0);
        SalesforceLoginConfig loginConfig = new SalesforceLoginConfig();
        IntrospectionSupport.setProperties((Object)loginConfig, salesforceOptions);
        SalesforceComponent component = new SalesforceComponent();
        component.setPackages("org.wildfly.camel.test.salesforce.dto");
        component.setLoginConfig(loginConfig);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addComponent("salesforce", (Component)component);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:query").to("salesforce:query?sObjectQuery=SELECT id,name from Opportunity&sObjectClass=" + QueryRecordsOpportunity.class.getName());
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            QueryRecordsOpportunity queryRecords = (QueryRecordsOpportunity)((Object)producer.requestBody("direct:query", null, QueryRecordsOpportunity.class));
            Assert.assertNotNull((String)"Expected query records result to not be null", (Object)((Object)queryRecords));
        }
        finally {
            camelctx.stop();
        }
    }

    protected Map<String, Object> createSalesforceOptions() throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (SalesforceOption option : SalesforceOption.values()) {
            String envVar = System.getenv(option.name());
            if (envVar == null || envVar.length() == 0) {
                options.clear();
                continue;
            }
            options.put(option.configPropertyName, envVar);
        }
        return options;
    }

    private static enum SalesforceOption {
        SALESFORCE_CONSUMER_KEY("clientId"),
        SALESFORCE_CONSUMER_SECRET("clientSecret"),
        SALESFORCE_USER("userName"),
        SALESFORCE_PASSWORD("password");

        private String configPropertyName;

        private SalesforceOption(String configPropertyName) {
            this.configPropertyName = configPropertyName;
        }
    }
}

