/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.threading.subA;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedThreadFactory;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.RejectableScheduledThreadPoolExecutor;
import org.apache.camel.util.concurrent.RejectableThreadPoolExecutor;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;

public class WildFlyCamelThreadPoolFactory
implements ThreadPoolFactory {
    @Resource
    private ManagedThreadFactory managedThreadFactory;

    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool((ThreadFactory)this.managedThreadFactory);
    }

    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory factory) {
        boolean allow = profile.getAllowCoreThreadTimeOut() != null ? profile.getAllowCoreThreadTimeOut() : false;
        return this.newThreadPool(profile.getPoolSize(), profile.getMaxPoolSize(), profile.getKeepAliveTime(), profile.getTimeUnit(), profile.getMaxQueueSize(), allow, profile.getRejectedExecutionHandler(), (ThreadFactory)this.managedThreadFactory);
    }

    public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, boolean allowCoreThreadTimeOut, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
        AbstractQueue workQueue;
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("CorePoolSize must be >= 0, was " + corePoolSize);
        }
        if (maxPoolSize < corePoolSize) {
            throw new IllegalArgumentException("MaxPoolSize must be >= corePoolSize, was " + maxPoolSize + " >= " + corePoolSize);
        }
        if (corePoolSize == 0 && maxQueueSize <= 0) {
            workQueue = new SynchronousQueue();
            corePoolSize = 1;
            maxPoolSize = 1;
        } else {
            workQueue = maxQueueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(maxQueueSize);
        }
        RejectableThreadPoolExecutor answer = new RejectableThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, (BlockingQueue)((Object)workQueue));
        answer.setThreadFactory((ThreadFactory)this.managedThreadFactory);
        answer.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        }
        answer.setRejectedExecutionHandler(rejectedExecutionHandler);
        return answer;
    }

    public ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        RejectedExecutionHandler rejectedExecutionHandler = profile.getRejectedExecutionHandler();
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        }
        RejectableScheduledThreadPoolExecutor answer = new RejectableScheduledThreadPoolExecutor(profile.getPoolSize().intValue(), (ThreadFactory)this.managedThreadFactory, rejectedExecutionHandler);
        if (profile.getMaxPoolSize() > 0) {
            return new SizedScheduledExecutorService((ScheduledThreadPoolExecutor)answer, (long)profile.getMaxQueueSize().intValue());
        }
        return answer;
    }
}

