/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.utils.ObjectNameFactory;
import org.jboss.modules.management.DependencyInfo;
import org.jboss.modules.management.ModuleLoaderMXBean;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ExportedPathsTest {
    private static final String FILE_BASEDIR = "basedir.txt";
    private static final String FILE_EXPORTED_PATH_PATTERNS = "exported-path-patterns.txt";
    private static final String BASELINE_EXPORTED_PATHS_TXT = "../../../modules/etc/baseline/exported-paths.txt";
    private static final Path FILE_EXPORTED_PATHS = Paths.get(System.getProperty("exportedPathsTxt", "../../../modules/etc/baseline/exported-paths.txt"), new String[0]);
    private static final Path FILE_MODULE_INFOS = Paths.get("target/module-infos.txt", new String[0]);
    private static final String MODULE_LOADER_OBJECT_NAME = "jboss.modules:type=ModuleLoader,name=LocalModuleLoader-2";
    private static final String MODULE_CAMEL_COMPONENT = "org.apache.camel.component";
    private static final String MODULE_CAMEL = "org.apache.camel";
    private static final String MODULE_WILDFLY_CAMEL_EXTRAS = "org.wildfly.camel.extras:main";

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"exported-paths-tests");
        archive.addAsResource("classloading/exported-path-patterns.txt", FILE_EXPORTED_PATH_PATTERNS);
        archive.addAsResource((Asset)new StringAsset(System.getProperty("basedir")), FILE_BASEDIR);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName oname = ObjectNameFactory.create((String)MODULE_LOADER_OBJECT_NAME);
        ModuleLoaderMXBean mbean = JMX.newMXBeanProxy(server, oname, ModuleLoaderMXBean.class);
        Path moduleInfos = this.resolvePath(FILE_MODULE_INFOS);
        try (PrintWriter pw = new PrintWriter(new FileWriter(moduleInfos.toFile()));){
            for (String module : new String[]{MODULE_CAMEL, MODULE_CAMEL_COMPONENT}) {
                pw.println(mbean.dumpModuleInformation(module));
                for (DependencyInfo depinfo : mbean.getDependencies(module)) {
                    String modinfo;
                    String moduleName = depinfo.getModuleName();
                    if (moduleName == null || moduleName.equals(MODULE_WILDFLY_CAMEL_EXTRAS)) continue;
                    try {
                        modinfo = mbean.dumpModuleInformation(moduleName);
                    }
                    catch (RuntimeException ex) {
                        String msg = ex.getMessage();
                        if (depinfo.isOptional() && msg.contains(moduleName + " not found")) continue;
                        throw ex;
                    }
                    pw.println(modinfo);
                    pw.println("[Exported Paths: " + moduleName + "]");
                    ArrayList modulePaths = new ArrayList(mbean.getModulePathsInfo(moduleName, true).keySet());
                    Collections.sort(modulePaths);
                    for (String path : modulePaths) {
                        if (!path.contains("/") || path.equals("org/apache")) continue;
                        pw.println(path);
                    }
                    pw.println();
                }
            }
            pw.flush();
        }
        Path exportedPaths = this.resolvePath(FILE_EXPORTED_PATHS);
        pw = new PrintWriter(new FileWriter(exportedPaths.toFile()));
        List<String> camelExtraDeps = this.getDependentModuleNames(mbean);
        try {
            for (String module : new String[]{MODULE_CAMEL, MODULE_CAMEL_COMPONENT}) {
                pw.println("[Exported Paths: " + module + "]");
                SortedMap modulePathsInfo = mbean.getModulePathsInfo(module, true);
                ArrayList modulePaths = new ArrayList(modulePathsInfo.keySet());
                Collections.sort(modulePaths);
                for (String path : modulePaths) {
                    String moduleName = this.getPathModuleLoaderName((List)modulePathsInfo.get(path));
                    if (!path.contains("/") || path.equals("org/apache") || camelExtraDeps.contains(moduleName)) continue;
                    pw.println(path);
                }
                pw.println();
            }
            pw.flush();
        }
        finally {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportedPaths() throws Exception {
        ArrayList<Pattern> patterns = null;
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        ArrayList excludePatterns = new ArrayList();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/exported-path-patterns.txt")));){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                if (line.startsWith("[includes]")) {
                    patterns = includePatterns;
                } else if (line.startsWith("[excludes]")) {
                    patterns = excludePatterns;
                } else if (line.length() > 0 && !line.startsWith("[")) {
                    patterns.add(Pattern.compile(line));
                }
                line = reader.readLine();
            }
        }
        Path exportedPaths = this.resolvePath(FILE_EXPORTED_PATHS);
        reader = new BufferedReader(new FileReader(exportedPaths.toFile()));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() > 0 && !line.startsWith("[")) {
                    boolean match = false;
                    for (Pattern pattern : includePatterns) {
                        if (!pattern.matcher(line).matches()) continue;
                        match = true;
                        break;
                    }
                    if (match) {
                        for (Pattern pattern : excludePatterns) {
                            if (!pattern.matcher(line).matches()) continue;
                            match = false;
                            break;
                        }
                    }
                    Assert.assertTrue((String)("Matching path: " + line), (boolean)match);
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path resolvePath(Path other) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/basedir.txt")));){
            Path path = Paths.get(reader.readLine(), new String[0]).resolve(other);
            return path;
        }
    }

    private List<String> getDependentModuleNames(ModuleLoaderMXBean mbean) {
        ArrayList<String> moduleNames = new ArrayList<String>();
        if (mbean.queryLoadedModuleNames().contains(MODULE_WILDFLY_CAMEL_EXTRAS)) {
            for (DependencyInfo dependencyInfo : mbean.getDependencies(MODULE_WILDFLY_CAMEL_EXTRAS)) {
                String moduleName = dependencyInfo.getModuleName();
                if (moduleName == null) continue;
                moduleNames.add(moduleName);
            }
        }
        return moduleNames;
    }

    private String getPathModuleLoaderName(List<String> moduleLoaders) {
        Pattern p;
        Matcher m;
        String moduleName = "";
        if (moduleLoaders.size() > 0 && (m = (p = Pattern.compile(".*\\\"(.*)\\\".*")).matcher(moduleLoaders.get(0))).matches()) {
            moduleName = m.group(1);
        }
        return moduleName;
    }
}

