/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.infinispan;

import java.util.HashMap;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.infinispan.processor.idempotent.InfinispanIdempotentRepository;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.IdempotentRepository;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.WildFlyCamelContext;

@CamelAware
@RunWith(value=Arquillian.class)
public class InfinispanIntegrationTest {
    private static final String CACHE_KEY_NAME = "name";
    private static final String CACHE_KEY_AGE = "age";
    private static final String CACHE_VALUE_KERMIT = "Kermit";
    private static final String CACHE_VALUE_BOB = "Bob";
    private static final int CACHE_VALUE_AGE = 65;
    private CacheContainer cacheContainer;
    private WildFlyCamelContext camelctx;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-infinispan-test.jar");
        return archive;
    }

    @Before
    public void setUp() throws Exception {
        this.cacheContainer = new DefaultCacheManager();
        this.cacheContainer.start();
        this.camelctx = new WildFlyCamelContext();
        this.camelctx.getNamingContext().bind("java:jboss/infinispan/container/test", (Object)this.cacheContainer);
    }

    @After
    public void tearDown() throws Exception {
        this.camelctx.getNamingContext().unbind("java:jboss/infinispan/container/test");
        this.cacheContainer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheGet() throws Exception {
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:get").to("infinispan://localhost?cacheContainer=#java:jboss/infinispan/container/test&command=GET")).transform((Expression)this.simple("${headers.CamelInfinispanOperationResult}"))).to("mock:end");
            }
        });
        this.cacheContainer.getCache().put((Object)CACHE_KEY_NAME, (Object)CACHE_VALUE_KERMIT);
        this.camelctx.start();
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("CamelInfinispanKey", CACHE_KEY_NAME);
            ProducerTemplate template = this.camelctx.createProducerTemplate();
            String name = (String)template.requestBodyAndHeaders("direct:get", null, headers, String.class);
            Assert.assertEquals((Object)CACHE_VALUE_KERMIT, (Object)name);
        }
        finally {
            this.camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachePut() throws Exception {
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:put").to("infinispan://localhost?cacheContainer=#java:jboss/infinispan/container/test&command=PUT");
            }
        });
        this.camelctx.start();
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("CamelInfinispanKey", CACHE_KEY_NAME);
            headers.put("CamelInfinispanValue", CACHE_VALUE_KERMIT);
            ProducerTemplate template = this.camelctx.createProducerTemplate();
            template.requestBodyAndHeaders("direct:put", null, headers);
            String name = (String)this.cacheContainer.getCache().get((Object)CACHE_KEY_NAME);
            Assert.assertEquals((Object)CACHE_VALUE_KERMIT, (Object)name);
        }
        finally {
            this.camelctx.stop();
        }
    }

    @Test
    public void testCacheRemove() throws Exception {
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:remove").to("infinispan://localhost?cacheContainer=#java:jboss/infinispan/container/test&command=REMOVE");
            }
        });
        this.cacheContainer.getCache().put((Object)CACHE_KEY_NAME, (Object)CACHE_VALUE_KERMIT);
        this.camelctx.start();
        try {
            Assert.assertTrue((boolean)this.cacheContainer.getCache().containsKey((Object)CACHE_KEY_NAME));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("CamelInfinispanKey", CACHE_KEY_NAME);
            ProducerTemplate template = this.camelctx.createProducerTemplate();
            template.requestBodyAndHeaders("direct:remove", null, headers);
            Assert.assertFalse((boolean)this.cacheContainer.getCache().containsKey((Object)CACHE_KEY_NAME));
        }
        finally {
            this.camelctx.stop();
        }
    }

    @Test
    public void testCacheEntryCreatedEvent() throws Exception {
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("infinispan://localhost?cacheContainer=#java:jboss/infinispan/container/test&sync=false&eventTypes=CACHE_ENTRY_CREATED").to("mock:result");
            }
        });
        this.camelctx.start();
        try {
            this.cacheContainer.getCache().put((Object)CACHE_KEY_NAME, (Object)CACHE_VALUE_KERMIT);
            this.cacheContainer.getCache().put((Object)CACHE_KEY_AGE, (Object)65);
            MockEndpoint mockEndpoint = (MockEndpoint)this.camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(4);
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_CREATED");
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)true);
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_NAME);
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_CREATED");
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)false);
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_NAME);
            ((ValueBuilder)mockEndpoint.message(2).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_CREATED");
            ((ValueBuilder)mockEndpoint.message(2).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)true);
            ((ValueBuilder)mockEndpoint.message(2).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_AGE);
            ((ValueBuilder)mockEndpoint.message(3).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_CREATED");
            ((ValueBuilder)mockEndpoint.message(3).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)false);
            ((ValueBuilder)mockEndpoint.message(3).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_AGE);
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            this.camelctx.stop();
        }
    }

    @Test
    public void testCacheEntryRemovedEvent() throws Exception {
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("infinispan://localhost?cacheContainer=#java:jboss/infinispan/container/test&sync=false&eventTypes=CACHE_ENTRY_REMOVED").to("mock:result");
            }
        });
        this.cacheContainer.getCache().put((Object)CACHE_KEY_NAME, (Object)CACHE_VALUE_KERMIT);
        this.cacheContainer.getCache().put((Object)CACHE_KEY_AGE, (Object)65);
        this.camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)this.camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(2);
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_REMOVED");
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)true);
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanCacheName")).isNotNull();
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_NAME);
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_REMOVED");
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)false);
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanCacheName")).isNotNull();
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_NAME);
            this.cacheContainer.getCache().remove((Object)CACHE_KEY_NAME);
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            this.camelctx.stop();
        }
    }

    @Test
    public void testCacheEntryModifiedEvent() throws Exception {
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("infinispan://localhost?cacheContainer=#java:jboss/infinispan/container/test&sync=false&eventTypes=CACHE_ENTRY_MODIFIED").to("mock:result");
            }
        });
        this.cacheContainer.getCache().put((Object)CACHE_KEY_NAME, (Object)CACHE_VALUE_KERMIT);
        this.camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)this.camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(2);
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_MODIFIED");
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)true);
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanCacheName")).isNotNull();
            ((ValueBuilder)mockEndpoint.message(0).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_NAME);
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanEventType")).isEqualTo((Object)"CACHE_ENTRY_MODIFIED");
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanIsPre")).isEqualTo((Object)false);
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanCacheName")).isNotNull();
            ((ValueBuilder)mockEndpoint.message(1).outHeader("CamelInfinispanKey")).isEqualTo((Object)CACHE_KEY_NAME);
            this.cacheContainer.getCache().replace((Object)CACHE_KEY_NAME, (Object)CACHE_VALUE_BOB);
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            this.camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdempotentConsumer() throws Exception {
        final InfinispanIdempotentRepository messageIdRepository = new InfinispanIdempotentRepository((BasicCacheContainer)this.cacheContainer, "myProcessorName");
        this.camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.simple("${header.messageId}"), (IdempotentRepository)messageIdRepository).to("mock:result");
            }
        });
        this.camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)this.camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            ProducerTemplate template = this.camelctx.createProducerTemplate();
            for (int i = 0; i < 5; ++i) {
                template.requestBodyAndHeader("direct:start", null, "messageId", (Object)"12345");
            }
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            this.camelctx.stop();
        }
    }
}

