/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.irc;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class IRCIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-irc-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIRCComponent() throws Exception {
        final String ircHost = System.getenv("IRC_HOST");
        final String ircChannel = System.getenv("IRC_CHANNEL");
        Assume.assumeNotNull((Object[])new Object[]{ircHost, ircChannel});
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("irc:kermit@" + ircHost + "/#" + ircChannel).to("mock:messages");
            }
        });
        MockEndpoint endpoint = (MockEndpoint)camelctx.getEndpoint("mock:messages", MockEndpoint.class);
        endpoint.expectedMessageCount(3);
        endpoint.expectedBodiesReceived(new Object[]{"JOIN", "JOIN", "Hello Kermit!"});
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("irc:piggy@" + ircHost + "/#" + ircChannel, (Object)"Hello Kermit!");
            endpoint.assertIsSatisfied(5000L);
        }
        finally {
            camelctx.stop();
        }
    }
}

