/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.ldap;

import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryServiceBuilder.class);

    private DirectoryServiceBuilder() {
    }

    public static SetupResult setupDirectoryService(Class<?> testClass) throws Exception {
        CreateLdapServer ldapServerAnnotation;
        DirectoryServiceFactory dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
        SetupResult result = new SetupResult();
        result.directoryService = dsf.getDirectoryService();
        result.directoryService.getChangeLog().setEnabled(true);
        dsf.init("default" + UUID.randomUUID().toString());
        ApplyLdifFiles applyLdifFiles = testClass.getAnnotation(ApplyLdifFiles.class);
        if (applyLdifFiles != null) {
            LOG.debug("Applying {} to {}", (Object)applyLdifFiles.value(), (Object)testClass.getName());
            DSAnnotationProcessor.injectLdifFiles((Class)applyLdifFiles.clazz(), (DirectoryService)result.directoryService, (String[])applyLdifFiles.value());
        }
        if ((ldapServerAnnotation = testClass.getAnnotation(CreateLdapServer.class)) != null) {
            result.ldapServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)ldapServerAnnotation, (DirectoryService)result.directoryService);
            result.ldapServer.setDirectoryService(result.directoryService);
            result.ldapServer.start();
        }
        DirectoryServiceFactory dsFactory = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
        PartitionFactory partitionFactory = dsFactory.getPartitionFactory();
        LOG.debug("Using partition factory {}", (Object)partitionFactory.getClass().getSimpleName());
        return result;
    }

    public static void shutdownDirectoryService(DirectoryService service) throws Exception {
        if (service != null) {
            LOG.debug("Shuting down DS for {}", (Object)service.getInstanceId());
            service.shutdown();
            FileUtils.deleteDirectory((File)service.getInstanceLayout().getInstanceDirectory());
        }
    }

    public static long getCurrentRevision(DirectoryService dirService) throws Exception {
        if (dirService != null && dirService.getChangeLog().isEnabled()) {
            long revision = dirService.getChangeLog().getCurrentRevision();
            LOG.debug("Create revision {}", (Object)revision);
            return revision;
        }
        return 0L;
    }

    public static void revert(DirectoryService dirService, long revision) throws Exception {
        ChangeLog cl = dirService.getChangeLog();
        if (cl.isEnabled() && revision < cl.getCurrentRevision()) {
            LOG.debug("Revert revision {}", (Object)revision);
            dirService.revert(revision);
        }
    }

    static class SetupResult {
        private DirectoryService directoryService;
        private LdapServer ldapServer;

        SetupResult() {
        }

        public DirectoryService getDirectoryService() {
            return this.directoryService;
        }

        public LdapServer getLdapServer() {
            return this.ldapServer;
        }
    }
}

