/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.undertowjs;

import org.apache.camel.CamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.undertowjs.subA.UndertowJSRouteBuilder;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
@CamelAware
public class UndertowJSIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)new StringAsset("camelRoutes.js"), "undertow-scripts.conf")).addAsWebInfResource((Asset)new StringAsset("<jboss-web><context-root>test-undertowjs</context-root></jboss-web>"), "jboss-web.xml")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsWebResource("undertowjs/camelRoutes.js", "camelRoutes.js")).addClasses(new Class[]{HttpRequest.class, UndertowJSRouteBuilder.class});
    }

    @Test
    public void testUndertowJSCamelIntegration() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("undertowjs-context");
        Assert.assertNotNull((String)"Expected camel context to not be null", (Object)camelctx);
        HttpRequest.HttpResponse response = HttpRequest.get((String)"http://localhost:8080/test-undertowjs/greeting/Kermit").getResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Hello Kermit", (Object)response.getBody());
    }
}

