/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.cxf.interceptor.security.JAASLoginInterceptor;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Endpoint;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class CXFWSJAASAuthenticationIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-cxf-jaas-test.jar")).addClass(Endpoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCXFEndpointJAASAuthenticationSuccess() throws Exception {
        CamelContext camelctx = this.configureCamelContext("appl-pa$$wrd1");
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    @Test
    public void testCXFEndpointJAASAuthenticationFailure() throws Exception {
        CamelContext camelctx = this.configureCamelContext("invalid-password");
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.fail((String)"Expected CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Authentication failed"));
        }
        finally {
            camelctx.stop();
        }
    }

    private CamelContext configureCamelContext(String password) throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        CxfComponent component = new CxfComponent((CamelContext)camelctx);
        final CxfEndpoint consumerEndpoint = new CxfEndpoint("http://localhost:8080/webservices/greeting", component);
        consumerEndpoint.setServiceClass(Endpoint.class);
        List inInterceptors = consumerEndpoint.getInInterceptors();
        JAASLoginInterceptor interceptor = new JAASLoginInterceptor();
        interceptor.setContextName("other");
        inInterceptors.add(interceptor);
        final CxfEndpoint producerEndpoint = new CxfEndpoint("http://localhost:8080/webservices/greeting", component);
        producerEndpoint.setServiceClass(Endpoint.class);
        producerEndpoint.setUsername("user1");
        producerEndpoint.setPassword(password);
        Map properties = producerEndpoint.getProperties();
        if (properties == null) {
            producerEndpoint.setProperties(new HashMap());
        }
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((org.apache.camel.Endpoint)producerEndpoint);
                this.from((org.apache.camel.Endpoint)consumerEndpoint).process(exchange -> {
                    Object[] args = (Object[])exchange.getIn().getBody(Object[].class);
                    exchange.getOut().setBody((Object)("Hello " + args[0]));
                });
            }
        });
        return camelctx;
    }
}

