/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.sap.netweaver;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SAPNetweaverIntegrationTest {
    private static final String SAP_GATEWAY_URL = "https4://sapes4.sapdevcenter.com/sap/opu/odata/IWFND/RMTSAMPLEFLIGHT";

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-sap-netweaver-tests.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSAPNetweaverEndpoint() throws Exception {
        final String username = System.getenv("SAP_USERNAME");
        final String password = System.getenv("SAP_PASSWORD");
        Assume.assumeTrue((username != null && password != null ? 1 : 0) != 0);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").toF("sap-netweaver:%s?username=%s&password=%s", new Object[]{SAPNetweaverIntegrationTest.SAP_GATEWAY_URL, username, password});
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            ConsumerTemplate consumer = camelctx.createConsumerTemplate();
            String sapRssFeedUri = String.format("rss:%s/%s?username=%s&password=%s", SAP_GATEWAY_URL.replace("https4", "https"), "FlightCollection", username, password);
            SyndFeed feed = (SyndFeed)consumer.receiveBody(sapRssFeedUri, SyndFeed.class);
            Assert.assertNotNull((Object)feed);
            Assert.assertTrue((feed.getEntries().size() > 0 ? 1 : 0) != 0);
            SyndEntry entry = (SyndEntry)feed.getEntries().get(0);
            String sapCommand = entry.getTitle();
            String result = (String)producer.requestBodyAndHeader("direct:start", null, "CamelNetWeaverCommand", (Object)sapCommand, String.class);
            Assert.assertFalse((boolean)result.isEmpty());
        }
        finally {
            camelctx.stop();
        }
    }
}

