/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.security;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;
import org.wildfly.extension.camel.security.DomainPrincipal;
import org.wildfly.extension.camel.security.EncodedUsernamePasswordPrincipal;

@CamelAware
@RunWith(value=Arquillian.class)
public class AuthorizationPolicyTestCase {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"authorization-policy-route-test");
        archive.addAsResource("security/authorization-policy-camel-context.xml");
        return archive;
    }

    @Test
    public void testNoAuthenticationHeader() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("contextA");
        ProducerTemplate producer = camelctx.createProducerTemplate();
        try {
            producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException ex) {
            Throwable cause = ex.getCause();
            Assert.assertEquals(CamelAuthorizationException.class, cause.getClass());
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().startsWith("Cannot find the Authentication instance"));
        }
    }

    @Test
    public void testInvalidCredentials() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("contextA");
        ProducerTemplate producer = camelctx.createProducerTemplate();
        try {
            Subject subject = this.getAuthenticationToken("user-domain", "user2", "bogus");
            producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
            Assert.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException ex) {
            Throwable cause = ex.getCause();
            Assert.assertEquals(CamelAuthorizationException.class, cause.getClass());
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("Password invalid/Password required"));
        }
    }

    @Test
    public void testAuthenticatedAccess() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("contextA");
        ProducerTemplate producer = camelctx.createProducerTemplate();
        Subject subject = this.getAuthenticationToken("user-domain", "user2", "appl-pa$$wrd2");
        String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    @Test
    public void testRoleBasedAccess() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("contextB");
        ProducerTemplate producer = camelctx.createProducerTemplate();
        Subject subject = this.getAuthenticationToken("user-domain", "user2", "appl-pa$$wrd2");
        String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    @Test
    public void testInsufficientRoles() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("contextC");
        ProducerTemplate producer = camelctx.createProducerTemplate();
        try {
            Subject subject = this.getAuthenticationToken("user-domain", "user2", "appl-pa$$wrd2");
            producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "CamelAuthentication", (Object)subject, String.class);
            Assert.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException ex) {
            Throwable cause = ex.getCause();
            Assert.assertEquals(CamelAuthorizationException.class, cause.getClass());
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("User does not have required roles: [Role3]"));
        }
    }

    Subject getAuthenticationToken(String domain, String username, String password) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new DomainPrincipal(domain));
        subject.getPrincipals().add((Principal)new EncodedUsernamePasswordPrincipal(username, password.toCharArray()));
        return subject;
    }
}

