/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.servicenow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.servicenow.subA.Incident;
import org.wildfly.extension.camel.CamelAware;
import software.betamax.junit.Betamax;

@CamelAware
@RunWith(value=Arquillian.class)
public class ServiceNowIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"servicenow-tests")).addPackage(Incident.class.getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Betamax(tape="servicenow-search-incidents")
    public void testSearchIncidents() throws Exception {
        Map<String, Object> serviceNowOptions = this.createServiceNowOptions();
        Assume.assumeTrue((serviceNowOptions.size() == ServiceNowOption.values().length ? 1 : 0) != 0);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("servicenow:{{env:SERVICENOW_INSTANCE}}?userName={{env:SERVICENOW_USERNAME}}&password={{env:SERVICENOW_PASSWORD}}&oauthClientId={{env:SERVICENOW_CLIENT_ID}}&oauthClientSecret={{env:SERVICENOW_CLIENT_SECRET}}&release={{env:SERVICENOW_RELEASE}}&model.incident=org.wildfly.camel.test.servicenow.subA.Incident");
            }
        });
        camelctx.start();
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("CamelServiceNowResource", "table");
            headers.put("CamelServiceNowAction", "retrieve");
            headers.put(ServiceNowParams.PARAM_TABLE_NAME.getHeader(), "incident");
            ProducerTemplate producer = camelctx.createProducerTemplate();
            List result = (List)producer.requestBodyAndHeaders("direct:start", null, headers, List.class);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        }
        finally {
            camelctx.stop();
        }
    }

    protected Map<String, Object> createServiceNowOptions() throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (ServiceNowOption option : ServiceNowOption.values()) {
            String envVar = System.getenv(option.name());
            if (envVar == null || envVar.length() == 0) {
                options.clear();
                continue;
            }
            options.put(option.configPropertyName, envVar);
        }
        return options;
    }

    private static enum ServiceNowOption {
        SERVICENOW_INSTANCE("instanceName"),
        SERVICENOW_USERNAME("userName"),
        SERVICENOW_PASSWORD("password"),
        SERVICENOW_CLIENT_ID("oauthClientId"),
        SERVICENOW_CLIENT_SECRET("oauthClientSecret"),
        SERVICENOW_RELEASE("release");

        private String configPropertyName;

        private ServiceNowOption(String configPropertyName) {
            this.configPropertyName = configPropertyName;
        }
    }
}

