/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.threading;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ThreadPoolFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.threading.subA.InventoryService;
import org.wildfly.camel.test.threading.subA.WildFlyCamelThreadPoolFactory;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ThreadingIntegrationTest {
    @Resource(lookup="java:jboss/ee/concurrency/executor/default")
    ExecutorService executorService;
    @Inject
    WildFlyCamelThreadPoolFactory wildFlyCamelThreadPoolFactory;

    @Deployment
    public static JavaArchive createDeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-thread-tests.jar");
        archive.addPackage(WildFlyCamelThreadPoolFactory.class.getPackage());
        archive.addAsResource("threading/bigfile.csv", "bigfile.csv");
        archive.addAsResource("threading/smallfile.csv", "smallfile.csv");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomThreadPoolFactory() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.getExecutorServiceManager().setThreadPoolFactory((ThreadPoolFactory)this.wildFlyCamelThreadPoolFactory);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").log("Starting to process big file: ${header.CamelFileName}")).split((Expression)this.body().tokenize("\n")).streaming().parallelProcessing().bean(InventoryService.class, "csvToObject")).to("direct:update")).end().log("Done processing big file: ${header.CamelFileName}");
                ((RouteDefinition)this.from("direct:update").bean(InventoryService.class, "updateInventory")).to("mock:end");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:end", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(100);
            ProducerTemplate producerTemplate = camelctx.createProducerTemplate();
            producerTemplate.requestBody("direct:start", (Object)this.getClass().getResource("/bigfile.csv"));
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerManagedExecutorService() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").log("Starting to process big file: ${header.CamelFileName}")).split((Expression)this.body().tokenize("\n")).streaming().parallelProcessing().executorService(ThreadingIntegrationTest.this.executorService).bean(InventoryService.class, "csvToObject")).to("direct:update")).end().log("Done processing big file: ${header.CamelFileName}");
                ((RouteDefinition)this.from("direct:update").bean(InventoryService.class, "updateInventory")).to("mock:end");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:end", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(10);
            ProducerTemplate producerTemplate = camelctx.createProducerTemplate();
            producerTemplate.requestBody("direct:start", (Object)this.getClass().getResource("/smallfile.csv"));
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }
}

