/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.twitter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class TwitterIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() throws Exception {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-twitter-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostStatusUpdate() throws Exception {
        final CamelTwitterSupport twitter = new CamelTwitterSupport();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("twitter://timeline/user?" + twitter.getUriTokens());
            }
        });
        Assume.assumeTrue((boolean)twitter.hasUriTokens());
        camelctx.start();
        try {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yyyy");
            String message = "Its a good day to test Twitter on " + format.format(new Date());
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)message, String.class);
            Assert.assertTrue((String)("Unexpected: " + result), (boolean)result.contains("(wfcameltest) Its a good day to test Twitter"));
        }
        finally {
            camelctx.stop();
        }
    }

    static class CamelTwitterSupport {
        private String consumerKey;
        private String consumerSecret;
        private String accessToken;
        private String accessTokenSecret;

        CamelTwitterSupport() {
            Properties properties = new Properties();
            this.addProperty(properties, "consumer.key", "CAMEL_TWITTER_CONSUMER_KEY");
            this.addProperty(properties, "consumer.secret", "CAMEL_TWITTER_CONSUMER_SECRET");
            this.addProperty(properties, "access.token", "CAMEL_TWITTER_ACCESS_TOKEN");
            this.addProperty(properties, "access.token.secret", "CAMEL_TWITTER_ACCESS_TOKEN_SECRET");
            URL resurl = this.getClass().getResource("/test-options.properties");
            if (resurl != null) {
                try (InputStream inStream = resurl.openStream();){
                    properties.load(inStream);
                }
                catch (IOException ex) {
                    throw new IllegalAccessError("test-options.properties could not be found");
                }
            }
            this.consumerKey = properties.getProperty("consumer.key");
            this.consumerSecret = properties.getProperty("consumer.secret");
            this.accessToken = properties.getProperty("access.token");
            this.accessTokenSecret = properties.getProperty("access.token.secret");
        }

        boolean hasUriTokens() {
            return this.consumerKey != null && this.consumerSecret != null && this.accessToken != null && this.accessTokenSecret != null;
        }

        String getUriTokens() {
            return "consumerKey=" + this.consumerKey + "&consumerSecret=" + this.consumerSecret + "&accessToken=" + this.accessToken + "&accessTokenSecret=" + this.accessTokenSecret;
        }

        private void addProperty(Properties properties, String name, String envName) {
            String value;
            if (!properties.containsKey(name) && ObjectHelper.isNotEmpty((Object)(value = System.getenv(envName)))) {
                properties.setProperty(name, value);
            }
        }
    }
}

