/*
 * #%L
 * Wildfly Camel :: Testsuite
 * %%
 * Copyright (C) 2013 - 2016 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package org.wildfly.camel.test.irc;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

/**
 * To enable tests, set environment variables for your IRC host:
 *  IRC_HOST=irc.host.org:6667
 *  IRC_CHANNEL=wfc-test
 */
@CamelAware
@RunWith(Arquillian.class)
public class IRCIntegrationTest {

    static final String IRC_HOST = System.getenv("IRC_HOST");
    static final String IRC_CHANNEL = System.getenv("IRC_CHANNEL");
    
    @Deployment
    public static JavaArchive createDeployment() {
        return ShrinkWrap.create(JavaArchive.class, "camel-irc-tests");
    }

    @Test
    public void testIRCComponent() throws Exception {
        
        Assume.assumeNotNull("[#1678] Enable IRC testing in Jenkins", IRC_HOST, IRC_CHANNEL);

        CamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("irc:kermit@" + IRC_HOST + "/#" + IRC_CHANNEL)
                .to("mock:messages");
            }
        });

        MockEndpoint endpoint = camelctx.getEndpoint("mock:messages", MockEndpoint.class);
        endpoint.expectedMessageCount(3);

        // Expect a JOIN message for each user connection, followed by the actual IRC message
        endpoint.expectedBodiesReceived("JOIN", "JOIN", "Hello Kermit!");

        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("irc:piggy@" + IRC_HOST + "/#" + IRC_CHANNEL, "Hello Kermit!");
            endpoint.assertIsSatisfied(5000);
        } finally {
            camelctx.stop();
        }
    }
}
