/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SpringExcludedPathsTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-paths-tests");
        return archive;
    }

    @Test
    public void testAccessFromCamelSpringModule() throws Exception {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleIdentifier modid = ModuleIdentifier.create((String)"org.apache.camel.spring");
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        Class loadedClass = classLoader.loadClass("org.apache.camel.spring.SpringCamelContext");
        Assert.assertNotNull((String)"Class not null", (Object)loadedClass);
        loadedClass = classLoader.loadClass("org.apache.camel.spring.remoting.CamelServiceExporter");
        Assert.assertNotNull((String)"Class not null", (Object)loadedClass);
    }

    @Test
    public void testAccessFromDeployment() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> loadedClass = classLoader.loadClass("org.apache.camel.spring.SpringCamelContext");
        Assert.assertNotNull((String)"Class not null", loadedClass);
        try {
            classLoader.loadClass("org.apache.camel.spring.remoting.CamelServiceExporter");
            Assert.fail((String)"ClassNotFoundException expected");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

