/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.activemq;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.Component;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ActiveMQIntegrationTest {
    static final String QUEUE_NAME = "testQueue";
    @ArquillianResource
    InitialContext initialctx;
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static WebArchive createdeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-activemq-tests.war");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendMessage() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory();
        ActiveMQComponent activeMQComponent = new ActiveMQComponent();
        activeMQComponent.setConnectionFactory((ConnectionFactory)connectionFactory);
        camelctx.addComponent("activemq", (Component)activeMQComponent);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("activemq:queue:testQueue").transform((Expression)this.body().prepend((Object)"Hello "))).to("direct:end");
            }
        });
        PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
        pollingConsumer.start();
        camelctx.start();
        try (Connection con = connectionFactory.createConnection();){
            this.sendMessage(con, "Kermit");
            String result = (String)pollingConsumer.receive(5000L).getIn().getBody(String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveMessage() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory();
        ActiveMQComponent activeMQComponent = new ActiveMQComponent();
        activeMQComponent.setConnectionFactory((ConnectionFactory)connectionFactory);
        camelctx.addComponent("activemq", (Component)activeMQComponent);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("activemq:queue:testQueue");
            }
        });
        final StringBuffer result = new StringBuffer();
        final CountDownLatch latch = new CountDownLatch(1);
        camelctx.start();
        try (Connection con = connectionFactory.createConnection();){
            this.receiveMessage(con, new MessageListener(){

                public void onMessage(Message message) {
                    TextMessage text = (TextMessage)message;
                    try {
                        result.append(text.getText());
                    }
                    catch (JMSException ex) {
                        result.append(ex.getMessage());
                    }
                    latch.countDown();
                }
            });
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.asyncSendBody("direct:start", (Object)"Kermit");
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"Hello Kermit", (Object)result.toString());
        }
        finally {
            camelctx.stop();
        }
    }

    private ActiveMQConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
    }

    private void sendMessage(Connection connection, String message) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage msg = session.createTextMessage(message);
        producer.send((Message)msg);
        connection.start();
    }

    private void receiveMessage(Connection connection, MessageListener listener) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(QUEUE_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(listener);
        connection.start();
    }
}

