/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.bindy;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.bindy.csv.BindyCsvDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.bindy.model.Customer;

@RunWith(value=Arquillian.class)
public class BindyIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"bindy-tests");
        archive.addClasses(new Class[]{Customer.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshal() throws Exception {
        BindyCsvDataFormat bindy = new BindyCsvDataFormat(Customer.class);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)bindy){
            final /* synthetic */ DataFormat val$bindy;
            {
                this.val$bindy = dataFormat;
            }

            public void configure() throws Exception {
                this.from("direct:start").marshal(this.val$bindy);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)new Customer("John", "Doe"), String.class);
            Assert.assertEquals((Object)"John,Doe", (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        BindyCsvDataFormat bindy = new BindyCsvDataFormat(Customer.class);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)bindy){
            final /* synthetic */ DataFormat val$bindy;
            {
                this.val$bindy = dataFormat;
            }

            public void configure() throws Exception {
                this.from("direct:start").unmarshal(this.val$bindy);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer result = (Customer)producer.requestBody("direct:start", (Object)"John,Doe", Customer.class);
            Assert.assertEquals((Object)"John", (Object)result.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)result.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

