/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

@RunWith(value=Arquillian.class)
public class DOMRegistryTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"dom-registry-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemClassloader() throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
            Assert.assertNotNull((String)"DOMImplementation not null", (Object)domImpl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeploymentClassloader() throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = DOMRegistryTest.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
            Assert.assertNotNull((String)"DOMImplementation not null", (Object)domImpl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Test
    public void testDefaultClassloader() throws Exception {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
        Assert.assertNotNull((String)"DOMImplementation not null", (Object)domImpl);
    }
}

