/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.crypto;

import java.security.Key;
import javax.crypto.KeyGenerator;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.crypto.CryptoDataFormat;
import org.apache.camel.converter.crypto.PGPDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CryptoIntegrationTest {
    private static final String PUBRING_GPG = "pubring.gpg";
    private static final String SECRING_GPG = "secring.gpg";
    private static final String KEY_USERID = "sdude@nowhere.net";
    private static final String KEY_PASSWORD = "sdude";

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"crypto-tests");
        archive.addAsResource("crypto/pubring.gpg", PUBRING_GPG);
        archive.addAsResource("crypto/secring.gpg", SECRING_GPG);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalUnmarshallDes() throws Exception {
        KeyGenerator generator = KeyGenerator.getInstance("DES");
        final CryptoDataFormat cryptoFormat = new CryptoDataFormat("DES", (Key)generator.generateKey());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").marshal((DataFormat)cryptoFormat)).unmarshal((DataFormat)cryptoFormat);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"password", String.class);
            Assert.assertEquals((Object)"password", (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshallUnmarshallPgp() throws Exception {
        final PGPDataFormat encrypt = new PGPDataFormat();
        encrypt.setKeyFileName(PUBRING_GPG);
        encrypt.setKeyUserid(KEY_USERID);
        final PGPDataFormat decrypt = new PGPDataFormat();
        decrypt.setKeyFileName(SECRING_GPG);
        decrypt.setKeyUserid(KEY_USERID);
        decrypt.setPassword(KEY_PASSWORD);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").marshal((DataFormat)encrypt)).unmarshal((DataFormat)decrypt);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"password", String.class);
            Assert.assertEquals((Object)"password", (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }
}

