/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CXFResourcesTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-namespace-tests");
        return archive;
    }

    @Test
    public void testAccessFromCXFModule() throws Exception {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleIdentifier modid = ModuleIdentifier.create((String)"org.apache.cxf", (String)"3.0");
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        URL resurl = classLoader.getResource("META-INF/cxf/cxf.xml");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }

    @Test
    public void testAccessFromCXFComponentModule() throws Exception {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleIdentifier modid = ModuleIdentifier.create((String)"org.apache.camel.component.cxf");
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        URL resurl = classLoader.getResource("META-INF/cxf/cxf.xml");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }

    @Test
    public void testAccessFromCamelComponentModule() throws Exception {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleIdentifier modid = ModuleIdentifier.create((String)"org.apache.camel.component");
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        URL resurl = classLoader.getResource("META-INF/cxf/cxf.xml");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }

    @Test
    public void testAccessFromDeployment() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resurl = classLoader.getResource("META-INF/cxf/cxf.xml");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }
}

