/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.ws;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cxf.ws.subA.Endpoint;
import org.wildfly.camel.test.cxf.ws.subA.EndpointImpl;

@RunWith(value=Arquillian.class)
public class WebServiceProducerIntegrationTest {
    static final String SIMPLE_WAR = "simple.war";
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-ws-producer-tests");
        archive.addClasses(new Class[]{Endpoint.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleWar() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            QName serviceName = new QName("http://wildfly.camel.test.cxf", "EndpointService");
            Service service = Service.create((URL)this.getWsdl("/simple"), (QName)serviceName);
            Endpoint port = (Endpoint)service.getPort(Endpoint.class);
            Assert.assertEquals((Object)"Hello Foo", (Object)port.echo("Foo"));
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCxfProducer() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("cxf://" + WebServiceProducerIntegrationTest.this.getEndpointAddress("/simple") + "?serviceClass=" + Endpoint.class.getName());
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath + "/EndpointService";
    }

    private URL getWsdl(String contextPath) throws MalformedURLException {
        return new URL(this.getEndpointAddress(contextPath) + "?wsdl");
    }

    @Deployment(name="simple.war", managed=false, testable=false)
    public static Archive<?> getSimpleWar() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)SIMPLE_WAR);
        archive.addClasses(new Class[]{Endpoint.class, EndpointImpl.class});
        return archive;
    }
}

