/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.hl7;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HL7IntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"hl7-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalUnmarshal() throws Exception {
        String msg = "MSH|^~\\&|MYSENDER|MYRECEIVER|MYAPPLICATION||200612211200||QRY^A19|1234|P|2.4\r";
        final HL7DataFormat format = new HL7DataFormat();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").marshal((DataFormatDefinition)format)).unmarshal((DataFormatDefinition)format)).to("mock:result");
            }
        });
        camelctx.start();
        try {
            DefaultHapiContext context = new DefaultHapiContext();
            GenericParser p = context.getGenericParser();
            Message hapimsg = p.parse("MSH|^~\\&|MYSENDER|MYRECEIVER|MYAPPLICATION||200612211200||QRY^A19|1234|P|2.4\r");
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Message result = (Message)producer.requestBody("direct:start", (Object)hapimsg);
            Assert.assertEquals((Object)hapimsg.toString(), (Object)result.toString());
        }
        finally {
            camelctx.stop();
        }
    }
}

