/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jms;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsProvider;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@ServerSetup(value={JmsQueueSetup.class})
public class JMSIntegrationTest {
    static final String QUEUE_NAME = "camel-jms-queue";
    static final String QUEUE_JNDI_NAME = "java:/camel-jms-queue";
    @ArquillianResource
    InitialContext initialctx;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jms-tests");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.jboss.as.controller-client");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendMessage() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("jms:queue:camel-jms-queue?connectionFactory=ConnectionFactory").transform((Expression)this.body().prepend((Object)"Hello "))).to("direct:end");
            }
        });
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
        consumer.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            try (Connection conection = cfactory.createConnection();){
                this.sendMessage(conection, QUEUE_JNDI_NAME, "Kermit");
                String result = (String)consumer.receive().getIn().getBody(String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveMessage() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("jms:queue:camel-jms-queue?connectionFactory=ConnectionFactory");
            }
        });
        final StringBuffer result = new StringBuffer();
        final CountDownLatch latch = new CountDownLatch(1);
        camelctx.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            try (Connection connection = cfactory.createConnection();){
                this.receiveMessage(connection, QUEUE_JNDI_NAME, new MessageListener(){

                    public void onMessage(Message message) {
                        TextMessage text = (TextMessage)message;
                        try {
                            result.append(text.getText());
                        }
                        catch (JMSException ex) {
                            result.append(ex.getMessage());
                        }
                        latch.countDown();
                    }
                });
                ProducerTemplate producer = camelctx.createProducerTemplate();
                producer.asyncSendBody("direct:start", (Object)"Kermit");
                Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
                Assert.assertEquals((Object)"Hello Kermit", (Object)result.toString());
            }
        }
        finally {
            camelctx.stop();
        }
    }

    private void sendMessage(Connection connection, String jndiName, String message) throws Exception {
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)this.initialctx.lookup(jndiName);
        MessageProducer producer = session.createProducer(destination);
        TextMessage msg = session.createTextMessage(message);
        producer.send((Message)msg);
        connection.start();
    }

    private void receiveMessage(Connection connection, String jndiName, MessageListener listener) throws Exception {
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)this.initialctx.lookup(jndiName);
        MessageConsumer consumer = session.createConsumer(destination);
        consumer.setMessageListener(listener);
        connection.start();
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        private JMSOperations jmsAdminOperations;

        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            this.jmsAdminOperations = JMSOperationsProvider.getInstance((ManagementClient)managementClient);
            this.jmsAdminOperations.createJmsQueue(JMSIntegrationTest.QUEUE_NAME, JMSIntegrationTest.QUEUE_JNDI_NAME);
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            if (this.jmsAdminOperations != null) {
                this.jmsAdminOperations.removeJmsQueue(JMSIntegrationTest.QUEUE_NAME);
                this.jmsAdminOperations.close();
            }
        }
    }
}

