/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.ognl;

import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class OgnlIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ognl-tests");
        archive.addAsResource("ognl/test-ognl-expression.txt", "test-ognl-expression.txt");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOgnlExpression() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().ognl("request.body.name == 'Kermit'")).transform((Expression)this.simple("Hello ${body.name}"))).otherwise().to("mock:dlq");
            }
        });
        Person person = new Person();
        person.setName("Kermit");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)person, String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOgnlExpressionFromFile() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().ognl("resource:classpath:test-ognl-expression.txt")).transform((Expression)this.simple("Hello ${body.name}"))).otherwise().to("mock:dlq");
            }
        });
        Person person = new Person();
        person.setName("Kermit");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)person, String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    public static final class Person {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

