/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.policy;

import javax.ejb.EJBAccessException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.policy.subA.AnnotatedSLSB;
import org.wildfly.extension.camel.security.ClientLoginContext;

@RunWith(value=Arquillian.class)
public class EJBSecurityTestCase {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ejb-security-test");
        archive.addPackage(AnnotatedSLSB.class.getPackage());
        return archive;
    }

    @Test
    public void testAccessAllowed() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)bean.doAnything("Kermit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizedAccess() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        LoginContext lc = ClientLoginContext.newLoginContext((String)"user1", (String)"password1");
        lc.login();
        try {
            Assert.assertEquals((Object)"Hello Kermit", (Object)bean.doSelected("Kermit"));
        }
        finally {
            lc.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnauthorizedAccess() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        try {
            bean.doSelected("Kermit");
            Assert.fail((String)"Call to doSelected() method was expected to fail");
        }
        catch (EJBAccessException ejbae) {
            // empty catch block
        }
        LoginContext lc = ClientLoginContext.newLoginContext((String)"user1", (String)"wrongpass");
        lc.login();
        try {
            bean.doSelected("Kermit");
            Assert.fail((String)"Call to doSelected() method was expected to fail");
        }
        catch (EJBAccessException eJBAccessException) {
        }
        finally {
            lc.logout();
        }
    }

    @Test
    public void testAccessDenied() throws Exception {
        AnnotatedSLSB bean = this.lookup(new InitialContext(), AnnotatedSLSB.class, AnnotatedSLSB.class);
        try {
            bean.restrictedMethod();
            Assert.fail((String)"Call to restrictedMethod() method was expected to fail");
        }
        catch (EJBAccessException eJBAccessException) {
            // empty catch block
        }
    }

    private <T> T lookup(Context ctx, Class<?> beanClass, Class<T> viewClass) throws NamingException {
        return viewClass.cast(ctx.lookup("java:module/" + beanClass.getSimpleName() + "!" + viewClass.getName()));
    }
}

