/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.saxon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class XQueryIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"xquery-tests");
        archive.addAsResource("jaxb/customer.xml", "customer.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointClass() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Namespaces ns = new Namespaces("ns", "http://org/wildfly/test/jaxb/model/Customer");
                ((ProcessorDefinition)this.from("direct:start").transform().xquery("/ns:customer/ns:firstName", String.class, ns)).to("mock:result");
            }
        });
        camelctx.start();
        try {
            System.out.println(this.readCustomerXml());
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String customer = (String)producer.requestBody("direct:start", (Object)this.readCustomerXml(), String.class);
            Assert.assertEquals((Object)"John", (Object)customer);
        }
        finally {
            camelctx.stop();
        }
    }

    private String readCustomerXml() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)this.getClass().getResourceAsStream("/customer.xml"), (OutputStream)out);
        return new String(out.toByteArray());
    }
}

