/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.servlet;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.HttpRequest;
import org.wildfly.camel.test.common.HttpResponse;

@RunWith(value=Arquillian.class)
public class ServletIntegrationTest {
    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel.war");
        archive.addAsWebInfResource("servlet/web.xml", "web.xml");
        archive.addClasses(new Class[]{HttpRequest.class, HttpResponse.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletRoute() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("servlet://hello?servletName=CamelServletTest&matchOnUriPrefix=true").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setBody((Object)"Hello Kermit");
                    }
                });
            }
        });
        camelctx.start();
        try {
            HttpResponse result = HttpRequest.get((String)"http://localhost:8080/camel/services/hello").getResponse();
            Assert.assertEquals((Object)"Hello Kermit", (Object)result.getBody());
        }
        finally {
            camelctx.stop();
        }
    }
}

