/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import java.net.URL;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.spring.subA.HelloJeeBean;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class SpringJeeNamespaceTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jee-tests");
        archive.addAsResource("spring/jee-namespace-camel-context.xml");
        archive.addClasses(new Class[]{HelloJeeBean.class});
        return archive;
    }

    @Test
    public void testLoadHandlersFromSpringContext() throws Exception {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleIdentifier modid = ModuleIdentifier.create((String)"org.springframework.context");
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        URL resurl = classLoader.getResource("META-INF/spring.handlers");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }

    @Test
    public void testLoadHandlersFromCamel() throws Exception {
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        ModuleIdentifier modid = ModuleIdentifier.create((String)"org.apache.camel");
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        URL resurl = classLoader.getResource("META-INF/spring.handlers");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }

    @Test
    public void testLoadHandlersFromDeployment() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resurl = classLoader.getResource("META-INF/spring.handlers");
        Assert.assertNotNull((String)"URL not null", (Object)resurl);
    }

    @Test
    public void testJNDILookup() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("spring-jee");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertTrue((String)("Starts with: Hello Kermit using =>" + result), (boolean)result.startsWith("Hello Kermit using"));
        Assert.assertTrue((String)("Contains: ConnectionFactory =>" + result), (boolean)result.contains("ConnectionFactory"));
    }
}

