/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.sql;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.camel.PollingConsumer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SQLIntegrationTest {
    @Resource(mappedName="java:jboss/datasources/ExampleDS")
    DataSource dataSource;

    @Deployment
    public static JavaArchive createdeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-sql-tests.jar");
        archive.addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSQLEndpoint() throws Exception {
        Assert.assertNotNull((String)"DataSource not null", (Object)this.dataSource);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("sql:select name from information_schema.users?dataSource=java:jboss/datasources/ExampleDS").to("direct:end");
            }
        });
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
            pollingConsumer.start();
            String result = (String)((Map)pollingConsumer.receive().getIn().getBody(Map.class)).get("NAME");
            Assert.assertEquals((Object)"SA", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

