/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.cdi;

import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

final class CDIBeanArchiveProcessor
implements DeploymentUnitProcessor {
    CDIBeanArchiveProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        List subDeployments = depUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        if (!depSettings.isEnabled() || !WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)depUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)depUnit)) {
            return;
        }
        List deploymentArchives = depUnit.getAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES);
        BeanDeploymentArchiveImpl rootArchive = (BeanDeploymentArchiveImpl)depUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
        for (BeanDeploymentArchiveImpl bda : deploymentArchives) {
            if (bda.getBeanArchiveType().equals((Object)BeanDeploymentArchiveImpl.BeanArchiveType.EXTERNAL)) {
                for (BeanDeploymentArchive topLevelBda : rootArchive.getBeanDeploymentArchives()) {
                    bda.addBeanDeploymentArchive(topLevelBda);
                }
            }
            for (DeploymentUnit subDepUnit : subDeployments) {
                BeanDeploymentArchive subBda = (BeanDeploymentArchive)subDepUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
                bda.addBeanDeploymentArchive(subBda);
            }
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

