/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.cdi;

import java.util.List;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

final class CDIBeanArchiveProcessor
implements DeploymentUnitProcessor {
    CDIBeanArchiveProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        List subDeployments = depUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        if (!depSettings.isEnabled() || !WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)depUnit)) {
            return;
        }
        if (depUnit.getName().endsWith(".ear") && subDeployments.isEmpty()) {
            return;
        }
        List deploymentArchives = depUnit.getAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES);
        BeanDeploymentArchiveImpl rootArchive = (BeanDeploymentArchiveImpl)depUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
        for (BeanDeploymentArchiveImpl bda : deploymentArchives) {
            if (!bda.getBeanArchiveType().equals((Object)BeanDeploymentArchiveImpl.BeanArchiveType.EXTERNAL)) continue;
            for (BeanDeploymentArchive topLevelBda : rootArchive.getBeanDeploymentArchives()) {
                bda.addBeanDeploymentArchive(topLevelBda);
            }
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

