/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathTemplateHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.util.HttpString;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowHost;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.undertow.AbstractUndertowEventListener;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;

public class CamelUndertowHostService
extends AbstractService<UndertowHost> {
    private static final ServiceName SERVICE_NAME = CamelConstants.CAMEL_BASE_NAME.append(new String[]{"Undertow"});
    private final InjectedValue<SocketBinding> injectedHttpSocketBinding = new InjectedValue();
    private final InjectedValue<UndertowService> injectedUndertowService = new InjectedValue();
    private final InjectedValue<Host> injectedDefaultHost = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private final SubsystemState.RuntimeState runtimeState;
    private ServiceRegistration<UndertowHost> registration;
    private UndertowEventListener eventListener;
    private UndertowHost undertowHost;

    public static ServiceController<UndertowHost> addService(ServiceTarget serviceTarget, SubsystemState.RuntimeState runtimeState) {
        CamelUndertowHostService service = new CamelUndertowHostService(runtimeState);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addDependency(UndertowService.UNDERTOW, UndertowService.class, service.injectedUndertowService);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, service.injectedHttpSocketBinding);
        builder.addDependency(UndertowService.virtualHostName((String)"default-server", (String)"default-host"), Host.class, service.injectedDefaultHost);
        return builder.install();
    }

    private CamelUndertowHostService(SubsystemState.RuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    public void start(StartContext startContext) throws StartException {
        this.runtimeState.setHttpHost(this.getConnectionURL());
        this.eventListener = new CamelUndertowEventListener();
        ((UndertowService)this.injectedUndertowService.getValue()).registerListener(this.eventListener);
        this.undertowHost = new WildFlyUndertowHost((Host)this.injectedDefaultHost.getValue());
        ModuleContext syscontext = ((Runtime)this.injectedRuntime.getValue()).getModuleContext();
        this.registration = syscontext.registerService(UndertowHost.class, (Object)this.undertowHost, null);
    }

    private URL getConnectionURL() throws StartException {
        URL result;
        SocketBinding socketBinding = (SocketBinding)this.injectedHttpSocketBinding.getValue();
        InetAddress address = socketBinding.getNetworkInterfaceBinding().getAddress();
        try {
            String hostAddress = NetworkUtils.formatPossibleIpv6Address((String)address.getHostAddress());
            result = new URL(socketBinding.getName() + "://" + hostAddress + ":" + socketBinding.getPort());
        }
        catch (MalformedURLException ex) {
            throw new StartException((Throwable)ex);
        }
        return result;
    }

    public void stop(StopContext context) {
        ((UndertowService)this.injectedUndertowService.getValue()).unregisterListener(this.eventListener);
        this.registration.unregister();
    }

    public UndertowHost getValue() throws IllegalStateException {
        return this.undertowHost;
    }

    class CamelUndertowEventListener
    extends AbstractUndertowEventListener {
        CamelUndertowEventListener() {
        }

        public void onDeploymentStart(Deployment dep, Host host) {
            CamelUndertowHostService.this.runtimeState.addHttpContext(dep.getServletContext().getContextPath());
        }

        public void onDeploymentStop(Deployment dep, Host host) {
            CamelUndertowHostService.this.runtimeState.removeHttpContext(dep.getServletContext().getContextPath());
        }
    }

    class DelegatingHttpHandler
    implements HttpHandler {
        private Map<String, HttpHandler> delegates = new HashMap<String, HttpHandler>();

        DelegatingHttpHandler() {
        }

        void addDelegate(HttpHandlerRegistrationInfo reginfo, HttpHandler handler) {
            String methodRestrict = reginfo.getMethodRestrict();
            if (methodRestrict != null) {
                for (String method : methodRestrict.split(",")) {
                    this.checkedPut(method.trim(), handler);
                }
            } else {
                this.checkedPut("ALL", handler);
            }
        }

        private void checkedPut(String method, HttpHandler handler) {
            HttpHandler prev = this.delegates.put(method, handler);
            IllegalStateAssertion.assertNull((Object)prev, (String)("Handler for " + method + " already registered"));
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            HttpString method = exchange.getRequestMethod();
            HttpHandler delegate = this.delegates.get(method.toString());
            if (delegate == null) {
                delegate = this.delegates.get("ALL");
            }
            IllegalStateAssertion.assertNotNull((Object)delegate, (String)("Cannot obtain handler for method: " + method));
            delegate.handleRequest(exchange);
        }
    }

    class WildFlyUndertowHost
    implements UndertowHost {
        private static final String REST_PATH_PLACEHOLDER = "{";
        private final Map<String, DelegatingHttpHandler> handlers = new HashMap<String, DelegatingHttpHandler>();
        private final Host defaultHost;

        WildFlyUndertowHost(Host host) {
            this.defaultHost = host;
        }

        public void validateEndpointURI(URI httpURI) {
            boolean portMatched;
            boolean bl = portMatched = httpURI.getPort() == 0 || httpURI.getPort() == -1;
            if (!portMatched) {
                for (ListenerService service : this.defaultHost.getServer().getListeners()) {
                    InjectedValue binding = service.getBinding();
                    if (binding == null || ((SocketBinding)binding.getValue()).getPort() != httpURI.getPort()) continue;
                    portMatched = true;
                    break;
                }
            }
            if (!"localhost".equals(httpURI.getHost())) {
                CamelLogger.LOGGER.warn("Cannot bind to host other than 'localhost': {}", (Object)httpURI);
            }
            if (!portMatched) {
                CamelLogger.LOGGER.warn("Cannot bind to specific port: {}", (Object)httpURI);
            }
        }

        public void registerHandler(HttpHandlerRegistrationInfo reginfo, HttpHandler handler) {
            String path = reginfo.getUri().getPath();
            if (path.contains(REST_PATH_PLACEHOLDER)) {
                String pathPrefix = path.substring(0, path.indexOf(REST_PATH_PLACEHOLDER));
                String remaining = path.substring(path.indexOf(REST_PATH_PLACEHOLDER));
                PathTemplateHandler pathTemplateHandler = Handlers.pathTemplate();
                pathTemplateHandler.add(remaining, handler);
                handler = pathTemplateHandler;
                path = pathPrefix;
            } else if (!reginfo.isMatchOnUriPrefix().booleanValue()) {
                handler = Handlers.path((HttpHandler)handler);
            }
            DelegatingHttpHandler delhandler = this.handlers.get(path);
            if (delhandler == null) {
                delhandler = new DelegatingHttpHandler();
                this.defaultHost.registerHandler(path, (HttpHandler)delhandler);
                this.handlers.put(path, delhandler);
            }
            delhandler.addDelegate(reginfo, handler);
        }

        public void unregisterHandler(HttpHandlerRegistrationInfo reginfo) {
            String path = reginfo.getUri().getPath();
            if (path.contains(REST_PATH_PLACEHOLDER)) {
                path = path.substring(0, path.indexOf(REST_PATH_PLACEHOLDER));
            }
            this.defaultHost.unregisterHandler(path);
            this.handlers.remove(path);
        }
    }
}

