/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camel.generator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.catalog.WildFlyRuntimeProvider;
import org.wildfly.swarm.camel.generator.Main;

public class FractionsGenerator {
    public static final Logger LOG = LoggerFactory.getLogger((String)Main.class.getPackage().getName());
    private final Path outpath;
    private Map<String, Config> configs = new HashMap<String, Config>();

    public FractionsGenerator(Path outpath) throws IOException {
        this.outpath = outpath;
        try (InputStreamReader reader = new InputStreamReader(this.getResourceAsStream("fractions.config"));){
            this.configs = (Map)new ObjectMapper().readValue((Reader)reader, (TypeReference)new TypeReference<Map<String, Config>>(){});
        }
    }

    public void generate() throws IOException {
        this.allComponents(this.getComponents());
    }

    private void allComponents(SortedSet<Component> components) throws IOException {
        IllegalArgumentAssertion.assertNotNull(components, (String)"components");
        VelocityEngine ve = this.newVelocityEngine();
        VelocityContext context = new VelocityContext();
        context.put("components", components);
        String tmplPath = "templates/parent-pom.vm";
        try (InputStreamReader reader = new InputStreamReader(this.getResourceAsStream(tmplPath));){
            Path path = Paths.get("components", "pom.xml");
            LOG.info("Generating: {}", (Object)path);
            File outfile = this.outpath.resolve(path).toFile();
            outfile.getParentFile().mkdirs();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(outfile));){
                ve.evaluate((Context)context, (Writer)writer, tmplPath, (Reader)reader);
            }
        }
        for (Component comp : components) {
            this.singleComponent(comp);
        }
    }

    private void singleComponent(Component comp) throws IOException {
        IllegalArgumentAssertion.assertNotNull((Object)comp, (String)"comp");
        Config config = this.configs.get(comp.compId);
        if (config == null) {
            config = new Config();
        }
        if (config.moduleId == null) {
            config.moduleId = comp.compId;
        }
        VelocityEngine ve = this.newVelocityEngine();
        VelocityContext context = new VelocityContext();
        context.put("modId", (Object)config.moduleId);
        context.put("modules", config.modules);
        context.put("dependencies", this.getDependencies(config));
        context.put("features", this.getFeatures(config));
        context.put("compName", (Object)this.getComponentName(comp.compId));
        context.put("comp", (Object)comp);
        context.put("compId", (Object)comp.compId);
        String tmplPath = "templates/pom.vm";
        try (InputStreamReader reader = new InputStreamReader(this.getResourceAsStream(tmplPath));){
            Path path = Paths.get("components", comp.compId, "pom.xml");
            LOG.info("Generating: {}", (Object)path);
            File outfile = this.outpath.resolve(path).toFile();
            outfile.getParentFile().mkdirs();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(outfile));){
                ve.evaluate((Context)context, (Writer)writer, tmplPath, (Reader)reader);
            }
        }
        Path path = Paths.get("components", comp.compId, "module.conf");
        File outfile = this.outpath.resolve(path).toFile();
        try (PrintWriter writer = new PrintWriter(new FileWriter(outfile));){
            tmplPath = "templates/module.conf";
            InputStream input = this.getResourceAsStream(tmplPath);
            try (InputStreamReader reader = new InputStreamReader(input);){
                ve.evaluate((Context)context, (Writer)writer, tmplPath, (Reader)reader);
            }
        }
    }

    private SortedSet<Component> getComponents() throws IOException {
        Component comp;
        String schema;
        TreeSet<Component> components = new TreeSet<Component>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResourceAsStream("whitelist.txt")));){
            String line = reader.readLine();
            while (line != null) {
                String compId = line.trim();
                components.add(new Component(compId, "Component " + compId));
                line = reader.readLine();
            }
        }
        ArrayList<String> blacklist = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResourceAsStream("blacklist.txt")));
        Iterator iterator = null;
        try {
            String line = reader.readLine();
            while (line != null) {
                blacklist.add(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable line) {
            iterator = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (iterator != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        ((Throwable)((Object)iterator)).addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.setRuntimeProvider((RuntimeProvider)new WildFlyRuntimeProvider());
        for (String name : catalog.findComponentNames()) {
            schema = catalog.componentJSonSchema(name);
            if (schema != null) {
                comp = this.getComponent(new ObjectMapper().readTree(schema).get("component"));
                if (comp == null || blacklist.contains(comp.compId)) continue;
                components.add(comp);
                continue;
            }
            LOG.warn("Cannot obtain schema for: {}", (Object)name);
        }
        for (String name : catalog.findDataFormatNames()) {
            schema = catalog.dataFormatJSonSchema(name);
            if (schema != null) {
                comp = this.getComponent(new ObjectMapper().readTree(schema).get("dataformat"));
                if (comp == null || blacklist.contains(comp.compId)) continue;
                components.add(comp);
                continue;
            }
            LOG.warn("Cannot obtain schema for: {}", (Object)name);
        }
        for (String name : catalog.findLanguageNames()) {
            schema = catalog.languageJSonSchema(name);
            if (schema != null) {
                comp = this.getComponent(new ObjectMapper().readTree(schema).get("language"));
                if (comp == null || blacklist.contains(comp.compId)) continue;
                components.add(comp);
                continue;
            }
            LOG.warn("Cannot obtain schema for: {}", (Object)name);
        }
        for (String name : catalog.findOtherNames()) {
            schema = catalog.otherJSonSchema(name);
            if (schema != null) {
                comp = this.getComponent(new ObjectMapper().readTree(schema).get("other"));
                if (comp == null || blacklist.contains(comp.compId)) continue;
                components.add(comp);
                continue;
            }
            LOG.warn("Cannot obtain schema for: {}", (Object)name);
        }
        return components;
    }

    private Component getComponent(JsonNode node) throws IOException {
        String groupId = node.get("groupId").asText();
        String artifactId = node.get("artifactId").asText();
        String description = node.get("description").asText();
        Component result = null;
        if (!groupId.equals("org.apache.camel") || !artifactId.startsWith("camel-")) {
            LOG.info("Ignore: {}:{}", (Object)groupId, (Object)artifactId);
        } else if (!artifactId.equals("camel-core")) {
            result = new Component(artifactId.substring("camel-".length()), description);
        }
        return result;
    }

    private List<Dependency> getDependencies(Config config) throws IOException {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (String line : config.dependencies) {
            result.add(Dependency.parse(line));
        }
        return result;
    }

    private List<Dependency> getFeatures(Config config) throws IOException {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (String line : config.features) {
            result.add(Dependency.parse(line));
        }
        return result;
    }

    private String getComponentName(String compId) {
        return compId.toUpperCase().charAt(0) + compId.substring(1);
    }

    private VelocityEngine newVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    private InputStream getResourceAsStream(String resname) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resname);
        IllegalStateAssertion.assertNotNull((Object)stream, (String)("Cannot obtain resource stream: " + resname));
        return stream;
    }

    public static class Config {
        public String moduleId;
        public List<String> dependencies = Collections.emptyList();
        public List<String> features = Collections.emptyList();
        public List<String> modules = Collections.emptyList();
    }

    public static class Component
    implements Comparable<Component> {
        String compId;
        String description;

        Component(String compId, String description) {
            this.compId = compId;
            this.description = description;
        }

        public String getCompId() {
            return this.compId;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public int compareTo(Component obj) {
            return this.compId.compareTo(obj.compId);
        }
    }

    public static class Dependency {
        String groupId;
        String artifactId;
        Map<String, Boolean> flags = new HashMap<String, Boolean>();

        static Dependency parse(String line) {
            String[] tok;
            HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
            int idx = line.lastIndexOf(",");
            while (idx > 0) {
                String flag = line.substring(idx + 1);
                tok = flag.split("=");
                flags.put(tok[0], Boolean.parseBoolean(tok[1]));
                line = line.substring(0, idx);
                idx = line.lastIndexOf(",");
            }
            Dependency result = new Dependency();
            tok = line.split(":");
            result.groupId = tok[0];
            result.artifactId = tok[1];
            result.flags = flags;
            return result;
        }

        public String getSpec() {
            return this.groupId + ":" + this.artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean isExclusions() {
            Boolean result = this.flags.get("exclusions");
            return result != null ? result : false;
        }
    }
}

