/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.common;

import io.dekorate.utils.Serialization;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class WildFlySerialization
extends Serialization {
    public static KubernetesList unmarshalAsList(InputStream is) {
        String content = Strings.read((InputStream)is);
        String[] parts = WildFlySerialization.splitDocument(content);
        System.out.println("Found " + parts.length + " entries");
        ArrayList<HasMetadata> items = new ArrayList<HasMetadata>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            Object resource = WildFlySerialization.unmarshal((String)part.trim());
            if (resource instanceof KubernetesList) {
                items.addAll(((KubernetesList)resource).getItems());
                continue;
            }
            if (resource instanceof HasMetadata) {
                items.add((HasMetadata)resource);
                continue;
            }
            if (!(resource instanceof HasMetadata[])) continue;
            Arrays.stream((HasMetadata[])resource).forEach(r -> items.add((HasMetadata)r));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build();
    }

    private static String[] splitDocument(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        String[] lines = aSpecFile.split("\\r?\\n");
        StringBuilder builder = new StringBuilder();
        for (int nLine = 0; nLine < lines.length; ++nLine) {
            if ((lines[nLine].length() < "---".length() || lines[nLine].substring(0, "---".length()).equals("---")) && lines[nLine].length() >= "---".length()) {
                documents.add(builder.toString());
                builder.setLength(0);
                for (int i = 0; i <= nLine; ++i) {
                    builder.append(System.lineSeparator());
                }
                continue;
            }
            builder.append(lines[nLine] + System.lineSeparator());
        }
        if (!builder.toString().isEmpty()) {
            documents.add(builder.toString());
        }
        return documents.toArray(new String[documents.size()]);
    }
}

