/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.test.cloud.common.ConfigPlaceholderReplacement;
import org.wildfly.test.cloud.common.ConfigPlaceholderReplacer;
import org.wildfly.test.cloud.common.ExtraTestSetup;
import org.wildfly.test.cloud.common.KubernetesResource;
import org.wildfly.test.cloud.common.ValueInjector;
import org.wildfly.test.cloud.common.WildFlyKubernetesIntegrationTest;
import org.wildfly.test.cloud.common.WildFlyOpenshiftIntegrationTest;

class WildFlyIntegrationTestConfigDelegate {
    private final String namespace;
    private final List<KubernetesResource> kubernetesResources;
    private final Map<String, ConfigPlaceholderReplacer> placeholderReplacements;
    private final ExtraTestSetup extraTestSetup;
    private final Class<? extends ValueInjector>[] valueInjectors;

    private WildFlyIntegrationTestConfigDelegate(String namespace, KubernetesResource[] kubernetesResources, ConfigPlaceholderReplacement[] placeholderReplacements, Class<? extends ExtraTestSetup> additionalTestSetupClass, Class<? extends ValueInjector>[] valueInjectors) {
        this.namespace = namespace;
        this.kubernetesResources = new ArrayList<KubernetesResource>(Arrays.asList(kubernetesResources));
        LinkedHashMap<String, ConfigPlaceholderReplacer> replacements = new LinkedHashMap<String, ConfigPlaceholderReplacer>();
        try {
            this.extraTestSetup = additionalTestSetupClass == null ? null : additionalTestSetupClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (ConfigPlaceholderReplacement replacement : placeholderReplacements) {
                replacements.put(replacement.placeholder(), replacement.replacer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        this.placeholderReplacements = replacements;
        this.valueInjectors = Arrays.copyOf(valueInjectors, valueInjectors.length);
    }

    static WildFlyIntegrationTestConfigDelegate create(WildFlyKubernetesIntegrationTest annotation) {
        return new WildFlyIntegrationTestConfigDelegate(annotation.namespace(), annotation.kubernetesResources(), annotation.placeholderReplacements(), annotation.extraTestSetup(), annotation.valueInjectors());
    }

    static WildFlyIntegrationTestConfigDelegate create(WildFlyOpenshiftIntegrationTest annotation) {
        return new WildFlyIntegrationTestConfigDelegate("", annotation.kubernetesResources(), annotation.placeholderReplacements(), annotation.extraTestSetup(), annotation.valueInjectors());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<KubernetesResource> getKubernetesResources() {
        return this.kubernetesResources;
    }

    public Map<String, ConfigPlaceholderReplacer> getPlaceholderReplacements() {
        return this.placeholderReplacements;
    }

    public ExtraTestSetup getExtraTestSetup() {
        return this.extraTestSetup;
    }

    void addAdditionalKubernetesResources(List<KubernetesResource> additionalKubernetesResources) {
        ArrayList<KubernetesResource> temp = new ArrayList<KubernetesResource>(additionalKubernetesResources);
        temp.addAll(this.kubernetesResources);
        this.kubernetesResources.clear();
        this.kubernetesResources.addAll(temp);
    }

    Class<? extends ValueInjector>[] valueInjectors() {
        return this.valueInjectors;
    }
}

